package com.yifu.cloud.plus.v1.business.controller.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.TBusWarningMessage;
import com.yifu.cloud.plus.v1.business.service.system.TBusWarningMessageService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ServiceNameConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;


/**
 * B端预警-系统消息表
 *
 * @author hgw
 * @date 2021-08-20 17:39:51
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tbuswarningMessage")
@Tag(name = "B端预警-系统消息表")
public class TBusWarningMessageController {

     private final TBusWarningMessageService tBusWarningMessageService;

     /**
      * 简单分页查询
      *
      * @param page               分页对象
      * @param tBusWarningMessage B端预警-系统消息表
      * @return
      */
	 @Operation(summary = "简单分页查询", description = "简单分页查询")
	 @GetMapping("/page")
     public R<IPage<TBusWarningMessage>> getTBusWarningPage(Page<TBusWarningMessage> page, TBusWarningMessage tBusWarningMessage) {
          YifuUser user = SecurityUtils.getUser();
          Map<String, List<Long>> roleMap = user.getClientRoleMap();
          List<Long> roleList = null;
          if (roleMap != null && !roleMap.isEmpty()) {
               roleList = roleMap.get(ServiceNameConstants.CLIENT_ID_HR_B);
          }
          return new R<>(tBusWarningMessageService.getTBusWarningMessagePage(page, tBusWarningMessage, roleList));
     }

}
