package com.yifu.cloud.plus.v1.business.service.cert.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.cert.TUpdateRecord;
import com.yifu.cloud.plus.v1.business.mapper.cert.TUpdateRecordMapper;
import com.yifu.cloud.plus.v1.business.service.cert.TUpdateRecordService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.util.equator.HrEquator;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

import static com.alibaba.fastjson.serializer.SerializerFeature.*;

/**
 * @ClassName TUpdateRecordServiceImpl
 * @Description 证件修改记录表
 * @Author fxj
 * @Created 2021/8/16 15:16
 * @Version 1.0
 */
@Service
public class TUpdateRecordServiceImpl extends ServiceImpl<TUpdateRecordMapper, TUpdateRecord> implements TUpdateRecordService {
    @Override
    public IPage<TUpdateRecord> getTUpdateRecordPage(Page<TUpdateRecord> page, TUpdateRecord updateRecord) {
        return baseMapper.getTUpdateRecordPage(page,updateRecord);
    }

    @Override
    public <T> TUpdateRecord saveModificationRecord(String id, String module, T oldInfo, T newInfo, Class<T> tClass) {
        return saveModificationRecord(id,module,null,oldInfo,newInfo,tClass);
    }

    /**
     * 生成修改记录
     * @Author fxj
     * @Date 2021-08-16
     * @param id
     * @param module
     * @param differenceKey 非空串必须以逗号结尾
     * @param oldInfo
     * @param newInfo
     * @param tClass
     * @return
     **/
    @Override
    public <T> TUpdateRecord saveModificationRecord(String id, String module, String differenceKey, T oldInfo, T newInfo, Class<T> tClass){
        try{

            //比较记录不影响业务逻辑，用try套住
            //比较差异
            differenceKey = HrEquator.comparisonValue(oldInfo, newInfo,differenceKey);
            //如果有差异保存差异
            if(Common.isNotNull(differenceKey)){
                TUpdateRecord record = new TUpdateRecord();
                YifuUser user = SecurityUtils.getUser();
                if (null != user){
                    record.setCreateUser(String.valueOf(user.getId()));
                    record.setCreateUserName(user.getNickname());
                }else {
                    record.setCreateUser("305");
                    record.setCreateUserName("管理员");
                }
                record.setModul(module);
                record.setDomainId(id);
                record.setCreateTime(LocalDateTime.now());
                record.setNewInfo(JSON.toJSONString(newInfo,features));
                record.setOldInfo(JSON.toJSONString(oldInfo,features));
                record.setDifferenceInfo(differenceKey);
                record.setFullClassName(tClass.getName());
                baseMapper.insert(record);
                return record;
            }
        }catch (Exception e){
            log.error(JSON.toJSON(oldInfo)+"插入修改记录报错>>>",e);
        }
        return null;
    }

    @Override
    public R<List<TUpdateRecord>> getRecordsByDomainId(String domainId) {
        if (Common.isEmpty(domainId)){
            return R.failed(CommonConstants.PARAM_INFO_ERROR);
        }
        return R.ok(baseMapper.selectList(Wrappers.<TUpdateRecord>query().lambda().eq(TUpdateRecord::getDomainId,domainId)));
    }

    private SerializerFeature[] features = new SerializerFeature[] {
            WriteMapNullValue, WriteNullNumberAsZero, WriteNullListAsEmpty,
            WriteNullStringAsEmpty,WriteDateUseDateFormat
    };
}
