package com.yifu.cloud.plus.v1.business.service.salary.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryConfigTitleRes;
import com.yifu.cloud.plus.v1.business.entity.system.TBusDept;
import com.yifu.cloud.plus.v1.business.mapper.salary.TBusSalaryConfigTitleResMapper;
import com.yifu.cloud.plus.v1.business.service.salary.TBusSalaryConfigTitleResService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * B端-原表表头与配置关联表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Service
public class TBusSalaryConfigTitleResServiceImpl extends ServiceImpl<TBusSalaryConfigTitleResMapper, TBusSalaryConfigTitleRes>
        implements TBusSalaryConfigTitleResService {

     /**
      * B端-原表表头与配置关联表简单分页查询
      *
      * @param tBusSalaryConfigTitleRes B端-原表表头与配置关联表
      * @return
      */
     @Override
     public IPage<TBusSalaryConfigTitleRes> getTBusSalaryConfigTitleResPage(Page<TBusSalaryConfigTitleRes> page
             , TBusSalaryConfigTitleRes tBusSalaryConfigTitleRes) {
          return baseMapper.getTBusSalaryConfigTitleResPage(page, tBusSalaryConfigTitleRes);
     }

     /**
      * list
      * @return
      */
     @Override
     public List<TBusSalaryConfigTitleRes> getResListByDeptId(Integer deptId) {
          return baseMapper.getResListByDeptId(deptId);
     }

     /**
      * @param mTitleConfig
      * @param saveType
      * @param user
      * @param dept
      * @Description: 保存或更新-配置
      * @Author: hgw
      * @Date: 2021/9/8 18:22
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.salary.TBusSalaryConfigTitleRes>
      **/
     @Override
     public List<TBusSalaryConfigTitleRes> saveOrUpdateRes(List<TBusSalaryConfigTitleRes> mTitleConfig, Integer saveType
             , YifuUser user, TBusDept dept) {
          TBusSalaryConfigTitleRes mc = new TBusSalaryConfigTitleRes();
          mc.setDeptId(dept.getId());
          mc.setSaveType(saveType);
          QueryWrapper<TBusSalaryConfigTitleRes> queryWrapperMc = new QueryWrapper<>();
          queryWrapperMc.setEntity(mc);
          List<TBusSalaryConfigTitleRes> mcList = this.list(queryWrapperMc);
          Map<String, String> mcMap = new HashMap<>();
          for (TBusSalaryConfigTitleRes mcs : mcList) {
               mcMap.put(mcs.getConfigId(), mcs.getId());
          }
          // 回传list
          List<TBusSalaryConfigTitleRes> mTitleConfigList = new ArrayList<>();
          // 组装数据回传
          this.initMcList(mTitleConfig, user, mcMap, mTitleConfigList, saveType);
          return mTitleConfigList;
     }

     /**
      * @param mTitleConfig
      * @param user
      * @param mcMap
      * @param mTitleConfigList
      * @Description: 组装数据回传
      * @Author: hgw
      * @Date: 2021-9-8 18:19:52
      * @return: void
      **/
     private void initMcList(List<TBusSalaryConfigTitleRes> mTitleConfig, YifuUser user, Map<String, String> mcMap
             , List<TBusSalaryConfigTitleRes> mTitleConfigList, Integer saveType) {
          for (TBusSalaryConfigTitleRes m : mTitleConfig) {
               m.setSaveType(saveType);
               if (mcMap.get(m.getConfigId()) != null) {
                    m.setId(mcMap.get(m.getConfigId()));
               }
               if (Common.isEmpty(m.getId())) {
                    if (Common.isNotNull(m.getExcelTitle())) {
                         this.save(m, user);
                         mTitleConfigList.add(m);
                    }
               } else {
                    if (Common.isEmpty(m.getExcelTitle())) {
                         this.removeById(m);
                    } else {
                         this.updateById(m);
                         mTitleConfigList.add(m);
                    }
               }
          }
     }

     /**
      * 新增记录
      *
      * @param mTitleConfig
      * @return R
      */
     private void save(TBusSalaryConfigTitleRes mTitleConfig, YifuUser user) {
          mTitleConfig.setCreateUserId(user.getId());
          mTitleConfig.setCreateUserName(user.getNickname());
          mTitleConfig.setCreateTime(LocalDateTime.now());
          this.save(mTitleConfig);
     }

}
