package com.yifu.cloud.plus.v1.business.service.salary.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.salary.TBusSalaryItem;
import com.yifu.cloud.plus.v1.business.mapper.salary.TBusSalaryItemMapper;
import com.yifu.cloud.plus.v1.business.service.salary.TBusSalaryItemService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * B端-薪酬明细表
 *
 * @author hgw
 * @date 2021-09-06 11:10:32
 */
@Service
public class TBusSalaryItemServiceImpl extends ServiceImpl<TBusSalaryItemMapper, TBusSalaryItem> implements TBusSalaryItemService {

     /**
      * B端-薪酬明细表简单分页查询
      *
      * @param tBusSalaryItem B端-薪酬明细表
      * @return
      */
     @Override
     public IPage<TBusSalaryItem> getTBusSalaryItemPage(Page<TBusSalaryItem> page, TBusSalaryItem tBusSalaryItem) {
          return baseMapper.getTBusSalaryItemPage(page, tBusSalaryItem);
     }

     @Override
     public List<TBusSalaryItem> getListBySalaryId(List<String> salaryIdList) {
          return baseMapper.getListBySalaryId(salaryIdList);
     }

}
