package com.yifu.cloud.plus.v1.business.service.salary.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.business.entity.salary.TSalaryStatisticsDepart;
import com.yifu.cloud.plus.v1.business.mapper.salary.TSalaryStatisticsDepartMapper;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryCurDepartQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsDepartPageQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsDepartQuery;
import com.yifu.cloud.plus.v1.business.service.salary.TSalaryStatisticsDepartService;
import com.yifu.cloud.plus.v1.business.util.BusinessCommonUtils;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsDepartVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryTotalVO;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description: 部门薪资变动统计表 service实现层
 * @author: wangweiguo
 * @date: 2021-09-06
 */
@Service
@AllArgsConstructor
public class TSalaryStatisticsDepartServiceImpl extends ServiceImpl<TSalaryStatisticsDepartMapper, TSalaryStatisticsDepart>
        implements TSalaryStatisticsDepartService {

    /**
     * 分页查询: 部门统计条件分页查询
     *
     * @param query 部门统计查询条件
     * @return: R<IPage < TSalaryStatisticsDepartVO>>
     * @author: wangweiguo
     * @date: 2021-09-06
     */
    @Override
    public R<IPage<TSalaryStatisticsDepartVO>> getListByPage(TSalaryStatisticsDepartPageQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        Page<TSalaryStatisticsDepartVO> page = new Page<>(query.getCurrent(), query.getSize());
        page.setOrders(query.getOrders());
        page = this.baseMapper.getListByPage(page, query);
        List<TSalaryStatisticsDepartVO> list = page.getRecords();
        initTreeData(list);
        return R.ok(page, CommonConstants.SEARCH_SUCCESS);
    }

    /**
     * 列表查询: 部门统计条件查询
     *
     * @param query 部门统计查询条件
     * @return: R<List < TSalaryStatisticsDepartVO>>
     * @author: wangweiguo
     * @date: 2021-09-06
     */
    @Override
    public R<List<TSalaryStatisticsDepartVO>> getList(TSalaryStatisticsDepartQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        List<TSalaryStatisticsDepartVO> list = this.baseMapper.getListByPage(query);
        initTreeData(list);
        return R.ok(list, CommonConstants.SEARCH_SUCCESS);
    }

    /**
     * 查询: 根据部门id查询当前部门合计
     *
     * @param query 单个部门统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-16
     */
    @Override
    public R<TSalaryTotalVO> getCurDepartSumData(TSalaryCurDepartQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        TSalaryTotalVO vo = this.baseMapper.getCurDepartSumData(query);
        return R.ok(vo, CommonConstants.SEARCH_SUCCESS);
    }

    /**
     * 查询: 根据部门id查询当前部门统计数据
     *
     * @param query 单个部门统计查询条件
     * @return: R<TSalaryStatisticsDepartVO>
     * @author: wangweiguo
     * @date: 2021-09-16
     */
    @Override
    public R<TSalaryStatisticsDepartVO> getCurDepartData(TSalaryCurDepartQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        TSalaryStatisticsDepartVO vo = this.baseMapper.getCurDepartData(query);
        return R.ok(vo, CommonConstants.SEARCH_SUCCESS);
    }

    /**
     * 将子查询的树状转为list
     *
     * @param list 包含children的
     */
    private void initTreeData(List<TSalaryStatisticsDepartVO> list) {
        for (TSalaryStatisticsDepartVO vo : list) {
            BeanUtil.copyProperties(vo.getChildren().get(0), vo, CopyOptions.create().setIgnoreProperties("departName", "departId", "treeLogo").setIgnoreNullValue(true));
        }
    }

    /**
     * 合计: 条件查询部门合计
     *
     * @param query 部门统计查询条件
     * @return: R<TSalaryDepartTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    @Override
    public R<TSalaryTotalVO> getSumDepartByParams(TSalaryStatisticsDepartQuery query) {
        query.setLastSalaryMonth(BusinessCommonUtils.getLastMonthByCurMonth(query.getSalaryMonth()));
        return R.ok(this.baseMapper.sumSalaryDepart(query), CommonConstants.SEARCH_SUCCESS);
    }

}




