package com.yifu.cloud.plus.v1.business.service.vacation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.dto.vacation.UpdateVacationRedundancyDTO;
import com.yifu.cloud.plus.v1.business.entity.vacation.TVacationMonitor;
import com.yifu.cloud.plus.v1.business.query.vacation.TVacationMonitorQuery;
import com.yifu.cloud.plus.v1.business.vo.vacation.TVacationMonitorVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.math.BigDecimal;
import java.util.List;

/**
 * @description: 假期监控表 service层
 * @author: huyc
 * @date: 2023/1/13
*/
public interface TVacationMonitorService extends IService<TVacationMonitor> {

    /**
     * @description: 分页查询: 条件分页查询
     * @param query 查询条件
     * @return: R<IPage<TVacationMonitorVO>>
	 * @author: huyc
	 * @date: 2023/1/13
    */
    R<IPage<TVacationMonitorVO>> getListByPage(TVacationMonitorQuery query);

    /**
     * @description: 导出：根据查询条件导出
     * @param query 查询条件
     * @return: R<List<TVacationMonitorVO>>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<List<TVacationMonitorVO>> exportByParams(TVacationMonitorQuery query);

    /**
     * @description: 保存或者更新监控记录
     * @param entity
     * @return: boolean
	 * @author: huyc
	 * @date: 2023/1/13
     */
    boolean saveOrUpdateData(TVacationMonitor entity);

    /**
     * @description: 批量保存 OR 新增
     * @param list
     * @return: boolean
	 * @author: huyc
	 * @date: 2023/1/13
     */
    boolean batchSaveOrUpdateData(List<TVacationMonitor> list);

    /**
     * @description: 查询：根据身份证号查询剩余年假
     * @param idcard
     * @return: com.yifu.cloud.v1.common.core.util.R<java.math.BigDecimal>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<BigDecimal> getNotUsedVacationDurationByIdCard(String idcard);

    /**
     * @description: 定时任务：内部服务调用，每天初始化员工年假信息
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<Boolean> buildMonitorData();

    /**
     * @description: 冗余更新：更新监控表中冗余的员工信息，电信工号和岗位
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<Boolean> updateRedundancyEmployeeFields(List<UpdateVacationRedundancyDTO> dtoList);

    /**
     * @description: 释放假期时长
     * @param empIdcard 身份证号
     * @param vacationDuration 假期时长
     * @param year 年份
     * @return: boolean
	 * @author: huyc
	 * @date: 2023/1/13
    */
    boolean releaseVacationDuration(String empIdcard, BigDecimal vacationDuration, String year);

    /**
     * @description: 消耗假期时长
     * @param empIdcard 身份证号
     * @param vacationDuration 假期时长
     * @param year 年份
     * @return: boolean
	 * @author: huyc
	 * @date: 2023/1/13
     */
    boolean consumeVacationDuration(String empIdcard, BigDecimal vacationDuration, String year);

    /**
     * @description: 根据假勤年份和身份证号查询年假监控信息
     * @param empIdcard 身份证号
     * @param year 假勤年份
     * @return: com.yifu.cloud.v1.hrobusiness.api.entity.vacation.TVacationMonitor
	 * @author: huyc
	 * @date: 2023/1/13
    */
    TVacationMonitor getMonitorByEmpIdcardAndYear(String empIdcard, String year);
}
