/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.check.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 手机号码校验
 *
 * @author fxj
 * @date 2022-06-20 17:29:03
 */
@Data
@TableName("t_check_mobile")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "手机号码校验")
public class TCheckMobile extends BaseEntity {

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="id")
    private String id;

    /**
     * 0:初始数据 1：API验证结果
     */
    @Schema(description ="0:初始数据 1：API验证结果")
    private String type;

    /**
     * 手机号码
     */
    @Schema(description ="手机号码")
    private String mobile;

    /**
     * 手机号所属区域。样例：省-市
     */
    @Schema(description ="手机号所属区域。样例：省-市")
    private String area;

    /**
     * 手机号运营商类型。样例：中国移动 GSM
     */
    @Schema(description ="手机号运营商类型。样例：中国移动 GSM")
    private String numbertype;

    /**
     * 是否收费，枚举值：1 ：收费 0：不收费
     */
    @Schema(description ="是否收费，枚举值：1 ：收费 0：不收费")
    private String chargesstatus;

    /**
     * 检测结果，枚举值：0：空号 1：实号 2：停机 3：库无 4：沉默号 5：风险号  10：配置异常
     */
    @Schema(description ="检测结果，枚举值：0：空号 1：实号 2：停机 3：库无 4：沉默号 5：风险号  10：配置或接口异常")
    private String status;

    /**
     * 响应code码解释
     */
    @Schema(description ="响应code码解释")
    private String message;


}
