package com.yifu.cloud.plus.v1.yifu.common.core.util.alisms;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;

import java.util.ArrayList;
import java.util.List;

public class YiFuSmsTookit {

    private YiFuSmsTookit() { throw new IllegalStateException("Utility class");}
    /**
     * 批量发送提前校验或封装签名
     * @Author fxj
     * @Date 2021-05-07
     * @param phones
     * @param templateParams
     * @param signName
     * @param templateCode
     * @return
     **/
    public static AliSmsResult sendBatchSms(List<String> phones,
                                            List<String> templateParams,
                                            String signName,
                                            String templateCode){

        if (null == phones || null == templateParams){
            return getSmsResult(CommonConstants.FAIL.toString(),"电话和变量参数不可为空！");
        }
        if (phones.size() != templateParams.size()){
            return getSmsResult(CommonConstants.FAIL.toString(),"电话号码与变量参数数据不一致！");
        }
        List<String> signNames= new ArrayList<>();
        List<ParamVo> templateParamList = new ArrayList<>();
        for (int i=0;i<phones.size();i++){
            signNames.add(signName);
        }
        ParamVo paramVo = null;
        for (String param:templateParams){
            paramVo = new ParamVo();
            paramVo.setName(param);
            templateParamList.add(paramVo);
        }
        return YiFuSmsUtil.sendBatchSms(phones,templateParamList, signNames,templateCode);
    }

    /**
     * 批量发送提前校验或封装签名
     * @Author fxj
     * @Date 2021-05-07
     * @param phones
     * @param templateParamList
     * @param signName
     * @param templateCode
     * @return
     **/
    public static AliSmsResult sendBusBatchSms(List<String> phones,
                                            List<ParamVo> templateParamList,
                                            String signName,
                                            String templateCode){
        if (null == phones || null == templateParamList){
            return getSmsResult(CommonConstants.FAIL.toString(),"电话和变量参数不可为空！");
        }

        List<String> signNames= new ArrayList<>();

        if (phones.size() != templateParamList.size()){
            return getSmsResult(CommonConstants.FAIL.toString(),"电话号码与变量参数数据不一致！");
        }

        for (int i=0;i<phones.size();i++){
            signNames.add(signName);
        }

        return YiFuSmsUtil.sendBatchSms(phones,templateParamList, signNames,templateCode);
    }

    private static AliSmsResult getSmsResult(String code,String msg){
        AliSmsResult aliSmsResult = new AliSmsResult();
        aliSmsResult.setCode(code);
        aliSmsResult.setMessage(msg);
        return aliSmsResult;
    }

    public static void main(String[] args) {
        List<String> list = new ArrayList<>();
        list.add("18909690612");
        list.add("18909690533");
        YiFuSmsUtil.querySendDetails(list,"","20210509",null,null);
    }
}
