package com.yifu.cloud.plus.v1.yifu.common.core.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * 项目下用户数据权限封装类
 * @author chenyuxi
 * @date 2025/2/24
 * @since 1.9.7
 */
@Data
public class UserPermissionVo implements Serializable {
	/**
	 * 全部权限（默认不是）
	 */
	private boolean haveAll = false;
	/**
	 * 部门ID集合
	 */
	private Set<String> departIdSet;

	/**
	 * 账号类型：0 管理员， 1 普通成员
	 */
	private String userType;

	/**
	 * 用户ID
	 */
	private String userId;
	/**
	 * 关联项目编码 fxj 2025-02-25
	 */
	private String projectNo;

	/**
	 * 关联项目名称 fxj 2025-02-25
	 */
	private String projectName;

	/**
	 * 关联项目ID fxj 2025-02-25
	 */
	private String projectId;

}
