/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.common.dapr.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/*
*
*
* @author fxj
* @date  2022-05-23 14:28
**/
@Data
@Component
@PropertySource("classpath:daprConfig.properties")
@ConfigurationProperties(value = "dapr.check", ignoreInvalidFields = false)
public class DaprCheckProperties {
	/*
	* @author fxj
	* @date  14:34
	* @Description  dapr sidercar url  如：http://localhost:3005/v1.0/invoke/
	**/
	String appUrl;
	/*
	* @author fxj
	* @date  14:35
	* @decription  app_id  如："yifu_upms_sider"
	**/
	String appId;
}
