package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptContractInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpIncomePushInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialPushInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprEkpProperties;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.*;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.List;

/**
 * @Author huyc
 * @Date 2024-02-28
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprEkpProperties.class)
public class EkpDaprUtils {

	@Autowired
	private DaprEkpProperties daprProperties;

	/**
	 * @Author huyc
	 * @Description 新增社保明细数据
	 * @Date 16:18 2024/02/28
	 * @Param
	 * @return
	 **/
	public R<EkpSocialPushInfoVo> pushSocialInfoToEkp(List<EkpPushSocialParam> unPushList) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpSocialPush/inner/pushSocialInfoToEkp", JSON.toJSONString(unPushList), EkpSocialPushInfoVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增公积金明细数据
	 * @Date 10:22 2024/03/06
	 * @Param
	 * @return
	 **/
	public R<EkpSocialPushInfoVo> pushFundInfoToEkp(List<EkpPushFundParam> unPushList) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpFundPush/inner/pushFundInfoToEkp", JSON.toJSONString(unPushList), EkpSocialPushInfoVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增工资明细数据
	 * @Date 10:23 2024/03/11
	 * @Param
	 * @return
	 **/
	public R<Boolean> pushSalaryInfoToEkp(List<EkpSalaryParam> unPushList) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpSalaryPush/inner/pushSalaryInfoToEkp", JSON.toJSONString(unPushList), Boolean.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增管理费明细数据
	 * @Date 9:23 2024/03/14
	 * @Param
	 * @return
	 **/
	public R<EkpIncomePushInfoVo> pushManagerInfoToEkp(EkpIncomeParamManage incomeParam) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpmanagerinfo/inner/pushManangerInfoToEkp", JSON.toJSONString(incomeParam), EkpIncomePushInfoVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增管理费明细数据
	 * @Date 9:23 2024/03/14
	 * @Param
	 * @return
	 **/
	public R<EkpSocialPushInfoVo> jobPushManagerInfoToEkp(List<EkpIncomeParamManage> incomeParam) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpmanagerinfo/inner/jobPushManagerInfoToEkp", JSON.toJSONString(incomeParam), EkpSocialPushInfoVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增风险金明细数据
	 * @Date 11:15 2024/03/18
	 * @Param
	 * @return
	 **/
	public R<EkpIncomePushInfoVo> pushRiskInfoToEkp(EkpIncomeParamRisk incomeParam) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpriskinfo/inner/pushRiskInfoToEkp", JSON.toJSONString(incomeParam), EkpIncomePushInfoVo.class, SecurityConstants.FROM_IN);
	}


	/**
	 * @Author huyc
	 * @Description 新增风险金明细数据
	 * @Date 11:15 2024/03/18
	 * @Param
	 * @return
	 **/
	public R<EkpSocialPushInfoVo> jobpushRiskInfoToEkp(List<EkpIncomeParamRisk> incomeParam) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpriskinfo/inner/jobPushRiskInfoToEkp", JSON.toJSONString(incomeParam), EkpSocialPushInfoVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * 根据事业部配置条件查找用户账号
	 * @author chenyuxi
	 * @date 2025/1/15
	 * @since 1.7.5
	 */
	public R<EkpDivisionInfoVo> getDivisionUsernameList(EkpDivisionInfoVo divisionInfoVo) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpShenhepeizhi/inner/getDivisionUsernameList",divisionInfoVo, EkpDivisionInfoVo.class, SecurityConstants.FROM_IN);
	}

	/**
	 * @Author huyc
	 * @Description 新增社保明细数据
	 * @Date 11:48 2025/06/18
	 * @Param
	 * @return
	 **/
	public R<EkpDeptContractInfoVo> selectContractInfoByDetptNo(EkpDeptContractInfoVo vo) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/ekpSocialPush/inner/selectContractInfoByDetptNo", JSON.toJSONString(vo), EkpDeptContractInfoVo.class, SecurityConstants.FROM_IN);
	}
}
