package com.yifu.cloud.plus.v1.yifu.ekp.util;

import cn.hutool.json.JSONObject;
import com.yifu.cloud.plus.v1.yifu.ekp.config.EkpSocialProperties;
import com.yifu.cloud.plus.v1.yifu.ekp.constant.EkpConstants;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpPushSocialParam;
import io.micrometer.core.instrument.util.StringUtils;
import lombok.extern.log4j.Log4j2;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/**
 * @Author huyc
 * @Date 2022/8/29
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(EkpSocialProperties.class)
public class EkpSocialUtil {
	@Autowired
	private EkpSocialProperties ekpProperties;

	public String sendToEKP(EkpPushSocialParam param){
		log.info("推送EKP开始--社保明细数据");
		RestTemplate yourRestTemplate = new RestTemplate();
		try{
			String formValues = new ObjectMapper().writeValueAsString(param);
			//指向EKP的接口url
			//把ModelingAppModelParameterAddForm转换成MultiValueMap
			JSONObject loginName = new JSONObject();
			loginName.append("LoginName",ekpProperties.getLoginName());
			String loginData = new ObjectMapper().writeValueAsString(loginName);
			MultiValueMap<String,Object> wholeForm = new LinkedMultiValueMap<>();
			//wholeForm.add("docSubject", new String(docSubject.getBytes("UTF-8"),"ISO-8859-1") );
			wholeForm.add("docSubject",ekpProperties.getDocSubject());
			wholeForm.add("docCreator", "{\"LoginName\":\"admin\"}");
			//wholeForm.add("docCreator", loginData);
			wholeForm.add("docStatus", ekpProperties.getDocStatus());
			wholeForm.add("fdModelId", ekpProperties.getFdModelId());
			wholeForm.add("fdFlowId", ekpProperties.getFdFlowId());
			//wholeForm.add("formValues", new String(formValues.getBytes("UTF-8"),"ISO-8859-1"));
			wholeForm.add("formValues", formValues);
			//wholeForm.add("formValues", new String("{\"fd_3adfe6af71a1cc\":\"王五\", \"fd_3adfe658c6229e\":\"2019-03-26\", \"fd_3adfe6592b4158\":\"这里内容\"}".getBytes("UTF-8"),"ISO-8859-1") );
			HttpHeaders headers = new HttpHeaders();
			//如果EKP对该接口启用了Basic认证，那么客户端需要加入
			//addAuth(headers,"yourAccount"+":"+"yourPassword");是VO，则使用APPLICATION_JSON
			headers.setContentType(MediaType.MULTIPART_FORM_DATA);
			//必须设置上传类型，如果入参是字符串，使用MediaType.TEXT_PLAIN；如果
			HttpEntity<MultiValueMap<String,Object>> entity = new HttpEntity<MultiValueMap<String,Object>>(wholeForm,headers);
			//有返回值的情况 VO可以替换成具体的JavaBean
			ResponseEntity<String> obj = yourRestTemplate.exchange(ekpProperties.getUrl(), HttpMethod.POST, entity, String.class);
			String body = obj.getBody();
			if (StringUtils.isBlank(body)){
				log.error(EkpConstants.SEND_FAILED);
				return null;
			}else{
				log.info(EkpConstants.SEND_SUCCESS+body);
				return body;
			}
		}catch (Exception e){
			log.info(e.getMessage());
			return null;
		}
	}

}
