package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 流程调用配置（子流程调用）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_node_transfer_config")
@Schema(description = "流程调用配置（子流程调用）")
public class TNodeTransferConfig extends Model<TNodeTransferConfig> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
	 @Schema(description = "主键")
     private String id;

     @NotBlank(message = "流程节点ID不能为空")
     @Length(max = 255, message = "流程节点ID不能超过255个字符")
	 @Schema(description = "流程节点ID")
     private String nodeId;

     @NotBlank(message = "流程ID不能为空")
     @Length(max = 255, message = "流程ID不能超过255个字符")
	 @Schema(description = "流程ID")
     private String processId;

     @NotBlank(message = "调用方式（0同步/1异步）不能为空")
     @Length(max = 1, message = "调用方式（0同步/1异步）不能超过1个字符")
	 @Schema(description = "调用方式（0同步/1异步）")
     private String transferType;

     @NotBlank(message = "是否拷贝数据（0是/1否）不能为空")
     @Length(max = 1, message = "是否拷贝数据（0是/1否）不能超过1个字符")
	 @Schema(description = "是否拷贝数据（0是/1否）")
     private String copyData;

     @NotBlank(message = "是否拷贝附件（0是/1否）不能为空")
     @Length(max = 1, message = "是否拷贝附件（0是/1否）不能超过1个字符")
	 @Schema(description = "是否拷贝附件（0是/1否）")
     private String copyAtta;

     @NotBlank(message = "启动者（0当前流程的启动者/1上一个活动的处理人/2指定一个启动者）不能为空")
     @Length(max = 1, message = "启动者（0当前流程的启动者/1上一个活动的处理人/2指定一个启动者）不能超过1个字符")
	 @Schema(description = "启动者（0当前流程的启动者/1上一个活动的处理人/2指定一个启动者）")
     private String starterType;

     @Length(max = 255, message = "启动者（STARTER_TYPE 为2时启用）不能超过255个字符")
	 @Schema(description = "启动者（STARTER_TYPE 为2时启用）")
     private String starter;
}
