package com.yifu.cloud.plus.v1.csp.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 入离职登记导出
 *
 * @author chenyuxi
 * @date 2025-03-21
 * @since 1.9.8
 */
@Data
@ColumnWidth(17)
public class EmployeeRegistrationHrAutoExportVo implements Serializable {

	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;

	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;

	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "手机号码")
	@Schema(description = "手机号码")
	@ExcelProperty("手机号码")
	private String empPhone;

	@ExcelAttribute(name = "就职岗位")
	@Schema(description = "就职岗位")
	@ExcelProperty("就职岗位")
	private String position;

	@ExcelAttribute(name = "登记类型")
	@Schema(description = "登记类型 1入职 2离职")
	@ExcelProperty("登记类型")
	private String feedbackType;

	@ExcelAttribute(name = "入/离职日期", isDate = true)
	@Schema(description = "入/离职日期")
	@ExcelProperty("入/离职日期")
	@DateTimeFormat("yyyy-MM-dd")
	private Date joinLeaveDate;

	@ExcelAttribute(name = "登记人")
	@Schema(description = "登记人")
	@ExcelProperty("登记人")
	private String registorUsername;

	@ExcelAttribute(name = "登记时间", isDate = true)
	@Schema(description = "登记时间")
	@ExcelProperty("登记时间")
	private Date createTime;

	@ExcelAttribute(name = "前端客服")
	@Schema(description = "前端客服")
	@ExcelProperty("前端客服")
	private String customerUsername;

	@ExcelAttribute(name = "数据来源")
	@Schema(description = "数据来源")
	@ExcelProperty("数据来源")
	private String dataSource;

	@ExcelAttribute(name = "处理状态")
	@Schema(description = "处理状态,0已接收,1未处理,2已处理")
	@ExcelProperty("处理状态")
	private String processStatus;

}
