package com.yifu.cloud.plus.v1.csp.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.csp.entity.TCspAttaInfo;
import com.yifu.cloud.plus.v1.csp.vo.TAttaInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 附件信息表
 *
 * @author huych
 * @date 2025-05-16 11:16:07
 */
public interface TAttaInfoService extends IService<TCspAttaInfo> {

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    IPage<TCspAttaInfo> getTAttaInfoPage(Page<TCspAttaInfo> page, TCspAttaInfo tAttaInfo);

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    List<TCspAttaInfo> getTAttaInfoList(TCspAttaInfo tAttaInfo);
	/**
	 * @param domainId 关联id
	 * @Description: 根据domainId获取附件
	 * @Author: hgw
	 * @Date: 2024/6/17 18:23
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo>
	 **/
	List<TCspAttaInfo> getTAttaInfoListByDoMainId(String domainId);

	TCspAttaInfo add(TCspAttaInfo attaInfo);

    void update(List<TCspAttaInfo> attaList, String domainId, String relationType);

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    Boolean batchOssFileDelete(List<TCspAttaInfo> delAttaList);

    List<TCspAttaInfo> getKeenAtta(LocalDateTime dayStart, Collection<String> values);

    Boolean updateDomainId(String domainId, List<String> ids);

	/**
	 * @param applyId
	 * @Description: 收入证明使用
	 * @Author: hgw
	 * @Date: 2023/2/22 10:50
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo>>
	 **/
	R<List<TCspAttaInfo>> getAttaByApplyId(String applyId);

	/**
	 * @param domainId 关联id
	 * @Description: 删除附件
	 * @Author: hgw
	 * @Date: 2024/6/20 14:50
	 * @return: void
	 **/
	void deleteByDomainId(String domainId);

	/**
	 * @Description: 详档变简档，删除身份证、其他附件、签名之外的附件
	 * @Author: hgw
	 * @Date: 2025/3/21 17:06
	 * @return: void
	 **/
	void deleteByDomainIdExceptionCard(String domainId);

	void deleteByDomainIdAndOther(String domainId);

	// 简档，仅删除身份证附件和(21（预入职申明签名）；22（预入职确认签名）；23（预入职pdf文)
	void deleteByDomainIdCard(String domainId);

	void deleteByDomainIdAndType(String domainId, int relationType);

    List<TAttaInfoVo> getAttInfoByParam(String departNo, String startDate, String endDate);

	int getAttInfoCountByParam(String departNo, String startDate, String endDate);
}
