/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 公积金明细表
 *
 * @author fxj
 * @date 2024-03-06 09:33:55
 */
@Data
@TableName("ekp_fund_info")
@EqualsAndHashCode()
@Schema(description = "公积金明细表")
public class EkpFundInfo {

	@TableId(type = IdType.ASSIGN_ID)
	private String fd_id;

	@Schema(description ="订单类型")
	private String fd_3add9dd7833db8;

	@Schema(description ="是否有预估")
	private String fd_3add9de0be85e4;

	@Schema(description ="与工资合并结算")
	private String fd_3add9e1a670144;

	@Schema(description ="项目编码")
	private String fd_3adfe8c70d3fd4;

	@Schema(description ="项目名称")
	private String fd_3adfe8c8468e54;

	/**
	 * 项目编码-原
	 **/
	private String fd_3cfe2da7e35daa;
	/**
	 * 项目名称-原
	 **/
	private String fd_3cfe2db5015d6e;

	@Schema(description ="单号")
	private String fd_3adfe95c169c48;

	@Schema(description ="客户编码")
	private String fd_3adfe8c73cb5a4;

	@Schema(description ="客户名称")
	private String fd_3adfe8c81a0e42;

	@Schema(description ="姓名")
	private String fd_3adfe8c79989d4;

	@Schema(description ="身份证号")
	private String fd_3adfe8c7e4cf7a;

	@Schema(description ="生成月份")
	private String fd_3adfe8cb96c41e;

	@Schema(description ="缴纳月份")
	private String fd_3adfe8cf632700;

	@Schema(description ="实际结算月份")
	private String fd_3adfe8cff746bc;

	@Schema(description ="预估单位部分")
	private Double fd_3adfeb4e8064a8;

	@Schema(description ="预估个人部分")
	private Double fd_3adfeb52a4d2e2;

	@Schema(description ="实缴单位部分")
	private Double fd_3adfeb52fbe966;

	@Schema(description ="实缴个人部分")
	private Double fd_3adfeb5366dd82;

	@Schema(description ="单位差异")
	private Double fd_3adfeb53c70f72;

	@Schema(description ="个人差异")
	private Double fd_3adfeb5413fb44;

	@Schema(description ="应收")
	private Double fd_3adfeb7b624f06;

	@Schema(description ="结算状态")
	private String fd_3add9ea428879a;

	@Schema(description ="收款状态")
	private String fd_3add9eaeed2560;

	@Schema(description ="结算单号")
	private String fd_3adfeb830523b6;

	@Schema(description ="收款单号")
	private String fd_3adfeb8489e6c2;

	@Schema(description ="应支出")
	private Double fd_3adfeb7bd97464;

	@Schema(description ="支出结算状态")
	private String fd_3add9edfbc6f7e;

	@Schema(description ="付款状态")
	private String fd_3add9eed23894a;

	@Schema(description ="支出缴纳单号")
	private String fd_3adfeb83a704c8;

	@Schema(description ="付款单号")
	private String fd_3adfeb84175f28;

	@Schema(description ="公积金账户")
	private String fd_3aeafa8cc144bc;

	@Schema(description ="是否全部结算")
	private String fd_3b13afd1ef7798;

	@Schema(description ="HRO结算月份")
	private Date fd_3b13d8f8fdfb76;

	@Schema(description ="项目台账ID")
	private String fd_3b16e37baa5650_text;

	@Schema(description ="项目台账ID(ID)")
	private String fd_3b16e37baa5650;

	@Schema(description ="是否为BPO业务")
	private String fd_3b178ec510bf48;

	@Schema(description ="个人应支")
	private Double fd_3b35a6989dfde8;

	@Schema(description ="单位应收")
	private Double fd_3b35a6518b73b2;

	@Schema(description ="单位应支")
	private Double fd_3b35a6992a20a4;

	@Schema(description ="个人应收")
	private Double fd_3b35a65138a7fc;

	@Schema(description ="薪酬申请编号")
	private String fd_3b3cabbf094f1a;

	@Schema(description ="变更记录")
	private String fd_3b3e41ef8db782;

	@Schema(description ="创建人姓名")
	private String fd_3b439246fcdc7c;

	@Schema(description ="缴纳地")
	private String fd_3b5cc4b2aae22a;

	@Schema(description ="公积金id")
	private String fd_3b10b38f90d138;

	@Schema(description ="我司到款单位")
	private String fd_3b01956c77864c	;

	@Schema(description ="创建时间")
	private Date createTime;

}
