/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 招行卡
 *
 * @author hgw
 * @date 2025-09-09 16:22:40
 */
@Data
@TableName("ekp_zhao_hang_detail_log")
@Schema(description = "招行卡")
public class EkpZhaoHangDetailLog {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	@Schema(description = "推送参数")
	private String fdParam;
	@Schema(description = "返回数据")
	private String fdData;
	@Schema(description = "推送时间")
	private LocalDateTime fdDatePush;
	@Schema(description = "收到时间")
	private LocalDateTime fdDateBack;

}
