/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 预警配置表
 *
 * @author fxj
 * @date 2025-07-21 09:49:56
 */
@Data
@Schema(description = "预警配置表")
public class BudgetWarningVo {

	/**
	 * 科目
	 */
	@Schema(description = "科目")
	private String km;
	/**
	 * 提醒时间
	 */
	@Schema(description = "提醒时间")
	private String at;
	/**
	 * 余额
	 */
	@Schema(description = "余额")
	private Double ye;
	/**
	 * 	比率
	 */
	@Schema(description = "比率")
	private Double bl;
	/**
	 * 二级成本中心
	 */
	@Schema(description = "二级成本中心")
	private String cbzx;
	/**
	 * 二级成本中心-提醒人
	 */
	@Schema(description = "二级成本中心-提醒人")
	private String txr;

	/**
	 * 阀值-剩余
	 */
	@Schema(description = "阀值-剩余")
	private Integer fz;
}
