package com.yifu.cloud.plus.v1.ekp.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankAtta;
import com.yifu.cloud.plus.v1.ekp.service.EkpBankAttaService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.OSSUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.net.URL;

/**
 * @author hgw拷贝自档案的附件
 * 文件上传接口
 */
@RestController
@RequestMapping("/fileUpload")
@Tag(name = "文件上传下载接口")
@Slf4j
public class FileUploadController {

	@Autowired
	private OSSUtil ossUtil;

	@Autowired
	private EkpBankAttaService ekpBankAttaService;

	/**
	 * 根据wxNo（皖信编号）获取银企付款的回单：
	 *
	 * @return R
	 * @author hgw
	 */
	@Operation(summary = "根据wxNo（皖信编号）获取银企付款的回单：--EKP调用接口", description = "根据wxNo（皖信编号）获取银企付款的回单：--EKP调用接口")
	@SysLog("根据wxNo（皖信编号）获取银企付款的回单：--EKP调用接口")
	@GetMapping("/getAttaListBySalaryId")
	public R<String> getAttaListBySalaryId(@RequestParam String wxNo) {
		String returnUrl = null;
		EkpBankAtta atta = ekpBankAttaService.getOne(Wrappers.<EkpBankAtta>query().lambda()
				.eq(EkpBankAtta::getFdLinkId, wxNo).last(CommonConstants.LAST_ONE_SQL));
		if (atta != null && Common.isNotNull(atta.getFdAttaSrc())) {
			URL url = ossUtil.getObjectUrl(null, atta.getFdAttaSrc());
			returnUrl = String.valueOf(url).replace("http", "https");
		}
		return R.ok(returnUrl);
	}
}
