package com.yifu.cloud.plus.v1.ekp.controller;

import com.icbc.api.response.JftApiPayrollQueryDetailResponseV1;
import com.yifu.cloud.plus.v1.ekp.service.IcbcTransactionFlowIssueService;
import com.yifu.cloud.plus.v1.ekp.service.ZhaoHangService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankAttaReturnVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 招行卡相关控制器
 * @author hgw
 * @date 2025-9-9 11:24:36
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/zhaoHang")
@Tag(name = "招行卡相关控制器")
public class ZhaoHangController {

	private final ZhaoHangService zhaoHangService;

	@Operation(summary = "每天获取招行卡流水", description = "每天获取招行卡流水")
	@Inner
	@PostMapping("/inner/doGetZhaoHangInfo")
	public R<String> doGetZhaoHangInfo() {
		return zhaoHangService.doGetZhaoHangInfo();
	}

	// 特殊情况使用，或者是测试，或者是历史数据，postDate 格式："2025-07-02"
	@Operation(summary = "测试接口，获取招行卡流水接口数据", description = "获取招行卡流水接口数据")
	@PostMapping("/doGetZhaoHangCore")
	public R<String> doGetZhaoHangCore(@RequestParam String postDate) {
		return zhaoHangService.doGetZhaoHangCore(postDate);
	}

}
