package com.yifu.cloud.plus.v1.ekp.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.ekp.entity.EkpSocialInfo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptContractInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpDeptInfoVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpSocialSumInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 社保明细表
 *
 * @author huyc
 * @date 2024-02-29 11:21:56
 */
@Mapper
public interface EkpSocialInfoMapper extends BaseMapper<EkpSocialInfo> {

	/**
	 * 获取所有项目信息
	 * @param
	 * @return
	 */
	List<EkpDeptInfoVo> getAllEkpDeptInfo();

	/**
	 * 根据身份证和生成月份获取费用合计
	 * @param
	 * @return
	 */
	EkpSocialSumInfoVo getCostSumInfo(@Param("card") String empIdCard, @Param("month") String createMonth);

	void updateSocialStatus(@Param("sql") String sql);

	/**
	 * 获取所有当天的到账明细的交易流水号
	 * @param
	 * @return
	 */
	List<Map<String,String>> getAllserioNo();

	/**
	 * 获取近三天的到账明细的交易流水号
	 * @param
	 * @return
	 */
	List<Map<String,String>> getAllserioNoLsatSevenDays();

	/**
	 * 获取需要拉流水的银行账户
	 * @param
	 * @return
	 */
	List<Map<String,String>> getAccountList();

	EkpDeptContractInfoVo selectContractInfoByDetptNo(@Param("deptNo") String deptNo);

	/**
	 * 获取所有工行卡bin信息
	 * @param
	 * @return
	 */
	List<String> getAllIcbcCardBinInfo();
}
