package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * @author licancan
 * @description 业务操作记录表 t_business_operate
 * @date 2022-12-08 10:20:16
 */
@TableName(value ="t_business_operate")
@Data
@Schema(description = "业务操作记录表")
public class TBusinessOperate extends BaseEntity {
	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 业务表id
     */
	@Schema(description = "业务表id")
    private String businessId;

	/**
	 * 原来的信息
	 */
	@Schema(description = "原来的信息")
	private String oldInfo;

	/**
	 * 新的信息
	 */
	@Schema(description = "新的信息")
	private String newInfo;

    /**
     * 操作描述
     */
	@Schema(description = "操作描述:差异的信息(属性名称，逗号隔开)")
    private String differenceInfo;

    /**
     * 备注
     */
	@Schema(description = "备注")
    private String remark;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}