package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author licancan
 * @description 商险操作表 t_insurance_operate
 * @date 2022-07-25 14:20:16
 */
@Data
@Schema(description = "商险操作表")
public class TInsuranceOperate implements Serializable {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 商险明细id
     */
	@Schema(description = "商险明细id")
    private String insuranceDetailId;

    /**
     * 操作描述 新增商险人员/批增商险人员/替换商险/变更所属项目/商险导出办理/商险办理成功/商险办理失败。。。。。
     */
	@Schema(description = "操作描述")
    private String operateDesc;

	/**
	 * 备注(审核意见)
	 */
	@Schema(description = "备注(审核意见)")
	private String remark;

	/**
	 * 是否显示 0不显示/1显示
	 */
	@Schema(description = "是否显示 0不显示/1显示")
	private Integer displayFlag;

    /**
     * 创建者
     */
	@Schema(description = "创建人")
    private String createBy;

	/**
	 * 创建人姓名
	 */
	@Schema(description = "创建人-姓名")
    private String createName;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private LocalDateTime createTime;

    private static final long serialVersionUID = 1L;
}