package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 减员信息表
 * @TableName t_insurance_refund
 */
@Data
@Tag(name = "减员信息表")
public class TInsuranceRefund extends BaseEntity {
    /**
     * 主键id
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 保单信息主键
     */
	@Schema(description = "保单信息主键")
    private String insDetailId;

	/**
	 * 订单编号
	 */
	@Schema(description = "订单编号")
	private String orderNo;

    /**
     * 减员状态
     */
	@Schema(description = "减员状态")
    private Integer reduceHandleStatus;

    /**
     * 退费金额
     */
	@Schema(description = "退费金额")
    private BigDecimal refundMoney;

    /**
     * 备注
     */
	@Schema(description = "备注")
    private String remark;

	/**
	 * 是否删除 0未删除/1删除
	 */
	@Schema(description = "是否删除 0否/1是")
	private Integer deleteFlag;

	/**
	 * 创建人所在部门
	 */
	@Schema(description = "创建人所在部门")
	private String createUserDeptId;

	/**
	 * 创建人所在部门名称
	 */
	@Schema(description = "创建人所在部门名称")
	private String createUserDeptName;

	/**
	 * 派单类型
	 */
	@Schema(description = " 购买类型， 1新增、3批增、4替换，5减员")
	private Integer buyType;


	private static final long serialVersionUID = 1L;


}