package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author licancan
 * @description 投保编辑入参
 * @date 2022-07-21 11:33:30
 */
@Data
@Schema(description = "投保编辑入参")
public class InsuranceEditParam  implements Serializable {
	private static final long serialVersionUID = -7742645628926325904L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	@NotBlank(message = "主键不能为空")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	@Size(max = 20, message = "员工姓名不可超过20位")
	@NotBlank(message = "员工姓名不能为空")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	@NotBlank(message = "员工身份证号不能为空")
	private String empIdcardNo;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	@NotBlank(message = "保单开始时间不能为空")
	private String policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	@NotBlank(message = "保单结束时间不能为空")
	private String policyEnd;

	/**
	 * 岗位
	 */
	@Schema(description = "岗位")
	@NotBlank(message = "岗位不能为空")
	private String post;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	@NotBlank(message = "险种名称不能为空")
	private String insuranceTypeName;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	@NotBlank(message = "保险公司名称不能为空")
	private String insuranceCompanyName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	@NotBlank(message = "购买标准不能为空")
	private String buyStandard;

	/**
	 * 商险购买地省code
	 */
	@Schema(description = "商险购买地省code")
	@NotNull(message = "商险购买地省ID不能为空")
	private Integer insuranceProvince;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
	@NotBlank(message = "商险购买地省不能为空")
	private String insuranceProvinceName;

	/**
	 * 商险购买地市code
	 */
	@Schema(description = "商险购买地市code")
	@NotNull(message = "商险购买地市ID不能为空")
	private Integer insuranceCity;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
	@NotBlank(message = "商险购买地市不能为空")
	private String insuranceCityName;

	/**
	 * 商险办理省code
	 */
	@Schema(description = "商险办理省code")
	@NotNull(message = "商险办理省ID不能为空")
	private Integer insuranceHandleProvince;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
	@NotBlank(message = "商险办理省不能为空")
	private String insuranceHandleProvinceName;

	/**
	 * 商险办理城市code
	 */
	@Schema(description = "商险办理城市code")
	@NotNull(message = "商险办理城市ID不能为空")
	private Integer insuranceHandleCity;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
	@NotBlank(message = "商险办理城市不能为空")
	private String insuranceHandleCityName;

	/***********************************以下字段由系统算出，前端不用传，是为了方便入库***********************************/
	/**
	 * 医疗额度
	 */
	@JsonIgnore
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@JsonIgnore
	private String dieDisableQuota;
	/**
	 * 险种主键
	 */
	@JsonIgnore
	private Long insuranceTypeId;
}
