package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.insurances.util.LocalDateConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;



/**
 * @author zhaji
 * @description 已投保查询返回类
 * @date 2022-07-21 09:46:09
 */
@Data
@Tag(name = "已投保查询返回类")
public class InsuredListVo implements Serializable {
	private static final long serialVersionUID = -6673220061558171816L;
	//订单编号、姓名、身份证、投保类型、项目、岗位、保单起止日期、购买月数、保单生效日期、保险公司、是否出险、险种、购买标准 减员状态、
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	@ExcelIgnore
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "投保类型")
	@ExcelAttribute(name = "投保类型", readConverterExp = "1=新增,3=批增,4=替换")
	private String buyType;
	/**
	 * 客户名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description ="客户")
	@ExcelProperty(value = "客户")
	private String unitName;

	/**
	 * 客户编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@Schema(description ="客户编码")
	@ExcelProperty(value = "客户编码")
	@ExcelIgnore
	private String unitNo;
	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目")
	private String projectName;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目编码")
	private String deptNo;


	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "岗位")
	private String post;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单开始日期",converter = LocalDateConverter.class)
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单结束日期",converter = LocalDateConverter.class)
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDate policyEnd;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保险公司")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "险种")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "购买标准(元)")
	private String buyStandard;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保(万元)")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身故或残疾(万元)")
	private String dieDisableQuota;

	/**
	 * 预估保费
	 */
	@Schema(description = "预估保费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "预估保费(元)")
	private BigDecimal estimatePremium;

	/**
	 * 实际保费
	 */
	@Schema(description = "实际保费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "实际保费(元)")
	private BigDecimal actualPremium;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单号")
	private String policyNo;

	/**
	 * 发票号
	 */
	@Schema(description = "发票号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "发票号")
	private String invoiceNo;

	/**
	 * 保单生效日期
	 */
	@Schema(description = "保单生效日期")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单生效日期",converter = LocalDateConverter.class)
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDate policyEffect;


	/**
	 * 减员状态 1待减员 2减员中3减员退回
	 */
	@Schema(description = "减员状态 1待减员 2减员中3减员退回")
	@ExcelIgnore
	private Integer reduceHandleStatus;

	/**
	 * 商险购买地省code
	 */
	@Schema(description = "商险购买地省code")
	@ExcelIgnore
	private Integer insuranceProvince;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
	@ExcelIgnore
	private String insuranceProvinceName;

	/**
	 * 商险购买地市code
	 */
	@Schema(description = "商险购买地市code")
	@ExcelIgnore
	private Integer insuranceCity;

	/**
	 * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@Schema(description = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	@ExcelIgnore
	private Integer buyHandleStatus;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险购买地")
	private String insuranceCityName;

	/**
	 * 商险办理省code
	 */
	@Schema(description = "商险办理省code")
	@ExcelIgnore
	private Integer insuranceHandleProvince;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
	@ExcelIgnore
	private String insuranceHandleProvinceName;

	/**
	 * 商险办理城市code
	 */
	@Schema(description = "商险办理城市code")
	@ExcelIgnore
	private Integer insuranceHandleCity;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险办理地")
	private String insuranceHandleCityName;

	/**
	 * 是否出险 0未出险 1已出险
	 */
	@Schema(description = "是否出险 0未出险 1已出险")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "是否出险", readConverterExp = "0=未出险,1=已出险")
	@ExcelProperty(value = "是否出险")
	private String isUse;

	/**
	 * 是否过期 0未过期 1已过期
	 */
	@Schema(description = "是否过期 0未过期 1已过期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "是否过期", readConverterExp = "0=未过期,1=已过期")
	@ExcelProperty(value = "是否过期")
	private String isOverdue;

	/**
	 * 是否有效 0有效 1无效
	 */
	@Schema(description = "是否有效 0有效 1无效")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelAttribute(name = "是否有效 ", readConverterExp = "0=有效,1=无效")
	@ExcelProperty(value = "是否有效")
	private String isEffect;

	/**
	 * 派单日期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "派单日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "派单日期",converter = LocalDateConverter.class)
	@DateTimeFormat("yyyy-MM-dd")
	private LocalDate createTime;

	/**
	 * 派单人
	 */
	@Schema(description = "创建人(派单人)")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "派单人")
	private String createName;

	/**
	 * 购买月数
	 */
	@Schema(description = "购买月数")
	@ExcelIgnore
	private Long buyMonth;

	/**
	 * 创建人所在部门名称
	 */
	@Schema(description = "创建人所在部门名称")
	@ExcelIgnore
	private String createUserDeptName;

	/**
	 * 封面抬头
	 */
	@Schema(description = "封面抬头")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "封面抬头")
	private String invoiceTitle;

	/**
	 * 被替换人姓名
	 */
	@Schema(description = "被替换人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "被替换人姓名")
	private String coverEmpName;

	/**
	 * 被替换人身份证号
	 */
	@Schema(description = "被替换人身份证号）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "被替换人身份证号")
	private String coverEmpIdcardNo;

	/**
	 * 被替换人项目名称
	 */
	@Schema(description = "被替换人项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "被替换人项目名称")
	private String coverProjectName;

	/**
	 * 被替换人封面抬头
	 */
	@Schema(description = "被替换人封面抬头")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "被替换人封面抬头")
	private String coverInvoiceTitle;

	/**
	 * 被替换人项目名称
	 */
	@Schema(description = "被替换人项目名称")
	@ExcelIgnore
	private String coverProjectNo;

	/**
	 * 替换人姓名
	 */
	@Schema(description = "替换人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "替换人姓名")
	private String replaceEmpName;

	/**
	 * 替换人身份证号
	 */
	@Schema(description = "替换人身份证号）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "替换人身份证号")
	private String replaceEmpIdcardNo;

	/**
	 * 替换人项目名称
	 */
	@Schema(description = "替换人项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "替换人项目名称")
	private String replaceProjectName;

	/**
	 * 替换人封面抬头
	 */
	@Schema(description = "替换人封面抬头")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "替换人封面抬头")
	private String replaceInvoiceTitle;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否地市自购")
	private String isAdress;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "备注")
	private String remark;

	@ExcelIgnore
	private String insuranceTypeId;
}
