package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;


/**
 * @author zhangyun
 * @description 退保成功列表
 * @date 2022-12-09 09:00:00
 */
@Data
@Tag(name ="退保成功列表")
public class RefundListVo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String projectName;


	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@Schema(description = " 投保类型， 1新增、3批增、4替换")
	private Integer buyType;


	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;


	/**
	 * 保险公司名称(冗余字段)
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 退款金额（元）
	 */
	@Schema(description = "退款金额（元）")
	private String refundMoney;

	/**
	 * 退至项目名称
	 */
	@Schema(description = "退至项目名称")
	private String returnProjectName;

	/**
	 * 退至员工姓名
	 */
	@Schema(description = "退至员工姓名")
	private String returnEmpName;

	/**
	 * 退至员工身份证号
	 */
	@Schema(description = "退至员工身份证号")
	private String returnEmpIdcardNo;

	/**
	 * 是否地市自购0是 1 否
	 */
	@Schema(description = "是否地市自购")
	private String isAdress;
}
