package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaji
 * @description 结算月变更
 * @date 2022-07-21 15:38:13
 */
@Data
@Tag(name = "结算月变更")
public class SettleMonthChangeCheckParam implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 商险id
	 */
	@Schema(description = "商险id")
	private String id;
	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工身份证号码
	 */
	@Schema(description = "员工身份证号码")
	private String empIdCardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保单开始日期
	 */
	@Schema(description = "保单开始日期")
	private String policyStart;

	/**
	 * 保单结束日期
	 */
	@Schema(description = "保单结束日期")
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

	/**
	 * 错误信息
	 */
	@Schema(description = "错误信息")
	private String errorMessage;

}
