package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaji
 * @description EKP结算信息表
 * @date 2022-08-24 17:37:21
 */
@Data
@Tag(name = "EKP结算信息表")
public class SettleVo implements Serializable {

	/**
	 * 主键id
	 */
	private String id;

	/**
	 * 结算id
	 */
	@Schema(description = "结算id")
	private String detailId;

	/**
	 * 预估单结算状态
	 */
	@Schema(description = "预估单结算状态:未结算、已结算、结算中、无需结算")
	private String estimateStatus;

	/**
	 * 实缴单结算状态
	 */
	@Schema(description = "实缴单结算状态:未结算、已结算、结算中、无需结算")
	private String actualStatus;


}
