package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhaji
 * @description TODO
 * @date 2022-07-26 15:28:49
 */
@Data
public class TInsuranceRefundDetail implements Serializable {
	/**
	 * 主键id
	 */
	private String id;

	/**
	 * 保单信息主键
	 */
	private String insDetailId;

	/**
	 * 减员状态
	 */
	private Integer reduceHandleStatus;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 保单编号
	 */
	@Schema(description = "保单编号")
	private String policyNo;

	/**
	 * 退费金额
	 */
	private BigDecimal refundMoney;

	/**
	 * 备注
	 */
	private String remark;

	/**
	 * 减员创建时间
	 */
	private LocalDateTime createTime;

	/**
	 * 减员创建人
	 */
	private String createBy;

	/**
	 * 减员创建人姓名
	 */
	private String createName;

	/**
	 * 是否删除 0未删除/1删除
	 */
	@Schema(description = "是否删除 0否/1是")
	private Integer deleteFlag;


	private static final long serialVersionUID = 1L;

}
