package com.yifu.cloud.plus.v1.yifu.insurances.config;

import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.config.MybatisPlusMetaObjectHandler;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.plugins.YifuPaginationInnerInterceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

import javax.sql.DataSource;

/**
 * @author zhaji
 * @description TODO
 * @date 2022-08-25 16:57:06
 */
@Configuration
@MapperScan(basePackages = "com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances", sqlSessionTemplateRef = "insurancesSqlSessionTemplate", sqlSessionFactoryRef = "insurancesSqlSessionFactory")
public class InsurancesDataSourceConfig {

	@Bean(name = "insurancesDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.insurances")
	@Primary
    public DataSource insurancesDataSource() {
		         return DataSourceBuilder.create().build();
	}
	@Bean
     public SqlSessionFactory insurancesSqlSessionFactory(@Qualifier("insurancesDataSource") DataSource dataSource) throws Exception {

		MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
		bean.setDataSource(dataSource);
		//多数据源 myMetaObjectHandler不起作用问题解决
		GlobalConfig globalConfig = new GlobalConfig();
		globalConfig.setMetaObjectHandler(new MybatisPlusMetaObjectHandler());
		globalConfig.setDbConfig(new GlobalConfig.DbConfig());
		globalConfig.setBanner(false);
		bean.setGlobalConfig(globalConfig);
		//添加XML目录
		ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
		try {
			bean.setMapperLocations(resolver.getResources("classpath:mapper/insurances/*.xml"));
			//分页插件配置,不配置分页插件无效,否则会出现total为0的情况
			bean.setPlugins(insurancesPlusInterceptor());
			SqlSessionFactory sqlSessionFactory = bean.getObject();
			sqlSessionFactory.getConfiguration().setMapUnderscoreToCamelCase(true);
			return sqlSessionFactory;
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e);
		}

/*		MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
		bean.setDataSource(dataSource);
		MybatisConfiguration configuration = new MybatisConfiguration();
		configuration.setMapUnderscoreToCamelCase(true);
		bean.setConfiguration(configuration);
		bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:mapper/insurances/*.xml"));
		return bean.getObject();*/
	}


	@Bean(name = "insurancesTransactionManager")
	@Primary
	public DataSourceTransactionManager insurancesTransactionManager(@Qualifier("insurancesDataSource") DataSource dataSource) {
		         return new DataSourceTransactionManager(dataSource);
	}
	@Bean
     public SqlSessionTemplate insurancesSqlSessionTemplate(@Qualifier("insurancesSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
		        return new SqlSessionTemplate(sqlSessionFactory);
	}
	@Bean
	public TransactionTemplate insurancesTransactionTemplate(@Qualifier("insurancesTransactionManager") DataSourceTransactionManager dataSourceTransactionManager) {
	         return new TransactionTemplate(dataSourceTransactionManager);
   }

	@Bean
	public MybatisPlusInterceptor insurancesPlusInterceptor() {
		MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
		interceptor.addInnerInterceptor(new YifuPaginationInnerInterceptor());
		return interceptor;
	}
}
