package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
public interface TEmployeeInsurancePreService extends IService<TEmployeeInsurancePre> {
    /**
     * 商险待办任务表简单分页查询
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return
     */
    IPage<TEmployeeInsurancePre> getTEmployeeInsurancePrePage(Page<TEmployeeInsurancePre> page, TEmployeeInsurancePreSearchVo tEmployeeInsurancePre);
	/**
	 * 商险待办任务表不分页查询
	 * @param tEmployeeInsurancePre 商险待办任务表
	 * @return
	 */
    List<TEmployeeInsurancePre> getTEmployeeInsurancePreNoPage(TEmployeeInsurancePreSearchVo tEmployeeInsurancePre);

	/**
	 * 查询商险待购买数量
	 * @param tEmployeeInsurancePre 查询商险待购买vo
	 * @return
	 */
	long getTEmployeeInsuranceCount(TEmployeeInsurancePreSearchVo tEmployeeInsurancePre);

	/**
	 * 商险待办任务表导出
	 * @param searchVo 商险待办任务表
	 * @return
	 */
    void listExport(HttpServletResponse response, TEmployeeInsurancePreSearchVo searchVo);

	/**
	 * 商险派单信息单个/批量确认
	 * @param idList id集合
	 * @return
	 */
    R confirm(List<String> idList);

	/**
	 * 商险派单信息批量派单
	 * @param idList id集合
	 * @param sameFlag 是否要做重复人员明细校验的标识 1 不需要 空需要
	 * @return
	 */
	R batchDispatcherInsurance(List<String> idList,String sameFlag, boolean pushQiWeiFlag);

	/**
	 * 新增商险待购买信息
	 * @param preVo
	 * @return
	 */
	Boolean saveInsurancePreInfo(EmployeeRegistrationPreVo preVo);

	/**
	 * 信息修改入口新增商险待购买信息
	 * @param pre
	 * @return
	 */
	Boolean updateInfoSaveInsurancePreInfo(EmployeeRegistrationPre pre);

	Boolean deleteInsurancePreInfo(EmployeeRegistrationPre pre);

	Boolean checkExitInsuanceIsProcess(EmployeeRegistrationPreVo preVo);

	TEmployeeInsuranceSelectVo selectInsurancePreInfoList(TEmployeeInsurancePreVo preVo);

	void updateInsurancePreCustomerName(EmployeeRegistrationCustomerUserUpdateVo updateVo);

	void pushWxConfrimMessage();

	void pushDisConfrimInsurances();

	/**
	 * @Description: 查询list
	 * @Author: hgw
	 * @Date: 2025/4/8 11:31
	 * @return: com.yifu.cloud.plus.v1.yifu.insurances.vo.EmployeePreLogListVo
	 **/
	EmployeePreLogListVo getListByEmpPreId(String empPreId);

	/**
	 * @Description: 先删后增
	 * @Author: hgw
	 * @Date: 2025/4/8 11:31
	 * @return: boolean
	 **/
	boolean saveOrUpdateInsuranceList(List<TEmployeeInsurancePre> preList);
	/**
	 * @Description: 清空
	 * @Author: hgw
	 * @Date: 2025/4/10 14:47
	 * @return: boolean
	 **/
	boolean deleteInsuranceByPreId(String preId);

	/**
	 * @param empPreId 入职确认信息表ID
	 * @Description: 获取商险已购买信息
	 * @Author: huych
	 * @Date: 2025/8/7 10:25
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsurancePreDetail>>
	 **/
	EmployeePreInsuranceListVo getExitInsuranceListByEmpPreId(String empPreId);
}
