package com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.constants.InsurancesConstants;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceOperate;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeStandard;
import com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances.TInsuranceTypeStandardMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceOperateService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceTypeService;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceTypeStandardService;
import com.yifu.cloud.plus.v1.yifu.insurances.util.ValidityUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type_standard(购买标准表)】的数据库操作Service实现
* @createDate 2022-07-18 17:19:41
*/
@Service
public class TInsuranceTypeStandardServiceImpl extends ServiceImpl<TInsuranceTypeStandardMapper, TInsuranceTypeStandard> implements TInsuranceTypeStandardService {
	@Resource
	private TInsuranceTypeService tInsuranceTypeService;

	@Resource
	private TInsuranceOperateService tInsuranceOperateService;


	/**
	 * 查询购买标准列表
	 *
	 * @author zhaji
	 * @param id 购买标准id
	 * @return {@link R}
	 */
	@Override
	public R getInsuranceTypeStandard(String id) {
		if (Common.isEmpty(id)){
			return R.failed("险种id为空");
		}
		TInsuranceType byId = tInsuranceTypeService.getById(id);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("当前险种信息不存在或已被删除");
		}
		LambdaQueryWrapper<TInsuranceTypeStandard> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeStandard::getDeleteFlag, CommonConstants.ZERO_INT)
				.eq(TInsuranceTypeStandard::getInsuranceTypeId,id);
		queryWrapper.orderByDesc(TInsuranceTypeStandard ::getCreateTime);
		return R.ok(list(queryWrapper));
	}

	/**
	 * 删除购买标准
	 *
	 * @author zhaji
	 * @param id 购买标准id
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R deleteInsuranceTypeStandard(String id) {
		YifuUser user = SecurityUtils.getUser();
		if(Common.isEmpty(id)){
			return R.failed("购买标准id不能为空");
		}
		TInsuranceTypeStandard byId = getById(id);
		if (Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("购买标准信息不存在或已被删除");
		}
		LambdaUpdateWrapper<TInsuranceTypeStandard> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.eq(TInsuranceTypeStandard::getId,id)
				.set(TInsuranceTypeStandard::getDeleteFlag, CommonConstants.ONE_INT)
				.set(TInsuranceTypeStandard :: getUpdateBy,user.getId())
				.set(TInsuranceTypeStandard :: getUpdateTime,LocalDateTime.now());
		update(updateWrapper);
		addOperate(byId,user, InsurancesConstants.DELETE_INSURANCE_TYPE_STANDARD);
		return R.ok("删除购买标准成功");
	}
	/**
	 * 新增购买标准
	 *
	 * @author zhaji
	 * @param insuranceTypeStandard 购买标准
	 * @return {@link R}
	 */
	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R saveInsuranceTypeStandard(TInsuranceTypeStandard insuranceTypeStandard) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(insuranceTypeStandard)){
			return R.failed("新增的购买标准信息为空");
		}
		String insuranceTypeId = insuranceTypeStandard.getInsuranceTypeId();
		TInsuranceType byId = tInsuranceTypeService.getById(insuranceTypeId);
		if ( Common.isEmpty(byId) || CommonConstants.ONE_INT == byId.getDeleteFlag()){
			return R.failed("险种信息不存在或已被删除");
		}
		String buyStandard = insuranceTypeStandard.getBuyStandard();
		String medicalQuota = insuranceTypeStandard.getMedicalQuota();
		String dieDisableQuota = insuranceTypeStandard.getDieDisableQuota();
		if (!ValidityUtil.validateMoney(buyStandard)){
			return R.failed("购买标准格式不正确");
		}
		if (!ValidityUtil.validateMoneyMax(buyStandard)){
			return R.failed(InsurancesConstants.INSURANCE_TYPE_STANDARD_MAX_ERROR);
		}
		if (StringUtils.isNotBlank(medicalQuota)){
			if (!ValidityUtil.validateStandard(medicalQuota)){
				return R.failed("请输入大于等于0的数字最多两位小数");
			}
			if (!ValidityUtil.validateMoneyMax(medicalQuota)){
				return R.failed(InsurancesConstants.MEDICAL_QUOTA_MAX_ERROR);
			}
		}
		if (StringUtils.isNotBlank(dieDisableQuota)){
			if (!ValidityUtil.validateStandard(dieDisableQuota)){
				return R.failed("请输入大于等于0的数字最多两位小数");
			}
			if (!ValidityUtil.validateMoneyMax(dieDisableQuota)){
				return R.failed(InsurancesConstants.DIE_DISABLE_QUOTA_MAX_ERROR);
			}
		}
		LambdaQueryWrapper<TInsuranceTypeStandard> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(TInsuranceTypeStandard::getInsuranceTypeId,insuranceTypeStandard.getInsuranceTypeId())
				.eq(TInsuranceTypeStandard::getBuyStandard,insuranceTypeStandard.getBuyStandard())
				.eq(TInsuranceTypeStandard::getDeleteFlag,CommonConstants.ZERO_INT);
		List<TInsuranceTypeStandard> list = list(queryWrapper);
		if(list.isEmpty()){
			insuranceTypeStandard.setDeleteFlag(CommonConstants.ZERO_INT);
			insuranceTypeStandard.setCreateBy(user.getId());
			insuranceTypeStandard.setCreateName(user.getNickname());
			insuranceTypeStandard.setCreateTime(LocalDateTime.now());
			save(insuranceTypeStandard);
			addOperate(insuranceTypeStandard,user, InsurancesConstants.NEW_INSURANCE_TYPE_STANDARD);
			return R.ok("新增购买标准成功");
		}else{
			return R.failed("该险种下购买标准已存在");
		}

	}

	/**
	 * 操作记录
	 *
	 * @author zhaji
	 * @param insuranceTypeStandard 购买标准信息
	 * @param user 登录用户
	 * @param operateDesc 操作描述
	 * @return void
	 */
	private void addOperate(TInsuranceTypeStandard insuranceTypeStandard,YifuUser user,String operateDesc){
		try {
			TInsuranceOperate operate = new TInsuranceOperate();
			operate.setInsuranceDetailId(insuranceTypeStandard.getId());
			operate.setOperateDesc(operateDesc);
			operate.setCreateBy(user.getId());
			operate.setCreateName(user.getNickname());
			operate.setCreateTime(LocalDateTime.now());
			tInsuranceOperateService.save(operate);
		}catch (Exception e){
			e.getStackTrace();
		}
	}

	@Override
	@Transactional(value = "insurancesTransactionManager" ,rollbackFor = {Exception.class})
	public R enableById(String id, String enable) {
		if (Common.isEmpty(id)
				|| Common.isEmpty(enable)
				|| !CommonConstants.ONE_STRING.equals(enable)
				&& !CommonConstants.ZERO_STRING.equals(enable)){
			return R.failed(CommonConstants.PARAM_IS_NOT_ERROR);
		}
		TInsuranceTypeStandard typeStandard = getById(id);
		if (Common.isEmpty(typeStandard)){
			return R.failed("当前购买标准信息不存在或已被删除");
		}
		typeStandard.setEnable(enable);
		baseMapper.updateById(typeStandard);
		return R.ok();
	}

	@Override
	public R<List<TInsuranceTypeStandard>> getInsuranceTypeStandardList(String riskId) {
		return R.ok(baseMapper.selectList(Wrappers.<TInsuranceTypeStandard>query().lambda()
				.eq(TInsuranceTypeStandard::getInsuranceTypeId,riskId)
				.eq(TInsuranceTypeStandard::getDeleteFlag,CommonConstants.ZERO_STRING)
				.eq(TInsuranceTypeStandard::getEnable,CommonConstants.ZERO_STRING)));
	}
}
