package com.yifu.cloud.plus.v1.job.compont;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprBusinessProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author wangweiguo
 * @description hrob端微服务定时任务
 * @date 22:31 2021/8/17
 **/
@Component(value = "businessTask")
@Slf4j
@EnableConfigurationProperties(DaprBusinessProperties.class)
public class BusinessTask {

    @Autowired
    private DaprBusinessProperties daprBusinessProperties;

		/**
		 * @Description: 发送短信定时任务
		 * @Author: huyc
		 * @Date: 2023/1/5 9:35
		 * @return: void
		 **/
		public void buildMonitorData(){
			log.info("------------初始化年假信息定时任务-开始------------");
			HttpDaprUtil.invokeMethodPost(daprBusinessProperties.getAppUrl(), daprBusinessProperties.getAppId(),
					"/vacationMonitor/inner/buildMonitorDataForCurrentYear", "", Object.class,
					SecurityConstants.FROM_IN);
			log.info("------------初始化年假信息定时任务-结束------------");
		}

    /**
     * @author fxj
     * @description 每天更新证件状态
     * @date 2021-08-23
     * @return void
     **/
    public void updateCertStatusTask() {
        log.info("------------扫描定时任务开始：定时更新B端证据状态信息开始------------");
		HttpDaprUtil.invokeMethodPost(daprBusinessProperties.getAppUrl(), daprBusinessProperties.getAppId(),
				"/tcertinfo/inner/updateCertStatusTask", "", Object.class,
				SecurityConstants.FROM_IN);
        log.info("------------扫描定时任务开始：定时更新B端证据状态信息结束------------");
    }

    /**
     * @Description: 发送短信定时任务
     * @Author: hgw
     * @Date: 2021/8/25 9:35
     * @return: void
     **/
    public void doBatchSendBusSms(){
        log.info("------------发送短信定时任务-开始------------");
		HttpDaprUtil.invokeMethodPost(daprBusinessProperties.getAppUrl(), daprBusinessProperties.getAppId(),
				"/tbuswarning/inner/doBatchSendBusSms", "", Object.class,
				SecurityConstants.FROM_IN);
        log.info("------------发送短信定时任务-结束------------");
    }

    /**
     * @Description: 短信状态更新定时任务
     * @Author: hgw
     * @Date: 2021/8/25 9:35
     * @return: void
     **/
    public void doUpdateSendBusSmsStatus(){
        log.info("------------短信状态更新定时任务-开始------------");
		HttpDaprUtil.invokeMethodPost(daprBusinessProperties.getAppUrl(), daprBusinessProperties.getAppId(),
				"/tbuswarning/inner/doUpdateSendBusSmsStatus", "", Object.class,
				SecurityConstants.FROM_IN);
        log.info("------------短信状态更新定时任务-结束------------");
    }

}
