package com.yifu.cloud.plus.v1.job.compont;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author fxj
 * @Date 2022/7/4
 * @Description 定时任务生成续签代办提醒
 * @Version 1.0
 */
@Component(value = "createContractAlertTask")
@Slf4j
@EnableConfigurationProperties(DaprArchivesProperties.class)
public class CreateContractAlertTask {
	@Autowired
	private DaprArchivesProperties daprArchivesProperties;

	/**
	 * @Author fxj
	 * @Description
	 * @Date 10:49 2022/6/15
	 * @Param
	 * @return
	 **/
	public void createContractAlertTask() {
		log.info("------------定时任务生成续签代办提醒-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tempcontractalert/taskCreateContractAlert","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务生成续签代办提醒-定时任务结束------------");
	}
}
