package com.yifu.cloud.plus.v1.permission.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.permission.service.SysRoleMenuResService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysRoleMenuRes;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleMenuResSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 新权限-角色-菜单-关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysrolemenures")
@Tag(name = "新权限-角色-菜单-关联表管理")
public class SysRoleMenuResController {

	private final SysRoleMenuResService sysRoleMenuResService;


	/**
	 * 简单分页查询
	 *
	 * @param page           分页对象
	 * @param sysRoleMenuRes 新权限-角色-菜单-关联表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<SysRoleMenuRes>> getSysRoleMenuResPage(Page<SysRoleMenuRes> page, SysRoleMenuResSearchVo sysRoleMenuRes) {
		return new R<>(sysRoleMenuResService.getSysRoleMenuResPage(page, sysRoleMenuRes));
	}

	/**
	 * 不分页查询
	 *
	 * @param sysRoleMenuRes 新权限-角色-菜单-关联表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	public R<List<SysRoleMenuRes>> getSysRoleMenuResNoPage(@RequestBody SysRoleMenuResSearchVo sysRoleMenuRes) {
		return R.ok(sysRoleMenuResService.noPageDiy(sysRoleMenuRes));
	}

	/**
	 * 通过id查询新权限-角色-菜单-关联表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('ekp_sysrolemenures_get')")
	@GetMapping("/{fdId}")
	@PreAuthorize("@pms.hasPermission('ekp_sysrolemenures_get')")
	public R<SysRoleMenuRes> getById(@PathVariable("fdId") String fdId) {
		return R.ok(sysRoleMenuResService.getById(fdId));
	}

}
