package com.yifu.cloud.plus.v1.permission.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiChuchai;
import com.yifu.cloud.plus.v1.yifu.permission.vo.QiWeiUserVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业微信出差
 *
 * @Entity generator.domain.TStatisticsProjectReimburse
 */
@Mapper
public interface EkpQiweiChuchaiMapper extends BaseMapper<EkpQiwiChuchai> {

	/**
	 * @param status 状态
	 * @Description: 获取全部的列表，用来： 拉取企业微信时，不覆盖数据
	 * 1.9.6版本优化：只查找：已被拉取的90天内的数据Map（定时任务最多拉取30天内的，手动执行是当天的。所以比对90天内的查重足够了。查全部数据对IO是浪费的）
	 * 用来： 拉取企E人事出差数据时，不覆盖数据
	 * @Author: hgw
	 * @Date: 2021/7/28 18:05
	 * @return: java.util.List<com.yifu.cloud.v1.hrms.api.entity.salary.TStatisticsProjectReimburse>
	 **/
	List<EkpQiwiChuchai> getAllInfo(@Param("status") String status,
									@Param("queryStartTime") String queryStartTime,@Param("queryEndTime") String queryEndTime);

	List<QiWeiUserVo> getQiYeWeiXinUserList();
}




