package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TDelayNodeConfig;
import com.yifu.cloud.plus.v1.yifu.process.service.TDelayNodeConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * 定时流程节点配置
 *
 * @author hgw
 * @date 2020-07-16 17:48:52
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tdelaynodeconfig")
@Tag(name = "定时流程节点配置")
public class TDelayNodeConfigController {

	 @Resource
     private TDelayNodeConfigService tDelayNodeConfigService;

     /**
      * 简单分页查询
      *
      * @param page             分页对象
      * @param tDelayNodeConfig 定时流程节点配置
      * @return
      */
	 @Operation(summary = "简单分页查询", description = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TDelayNodeConfig>> getTDelayNodeConfigPage(Page<TDelayNodeConfig> page, TDelayNodeConfig tDelayNodeConfig) {
          return R.ok(tDelayNodeConfigService.getTDelayNodeConfigPage(page, tDelayNodeConfig));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TDelayNodeConfig> getById(@PathVariable("id") String id) {
          return R.ok(tDelayNodeConfigService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tDelayNodeConfig
      * @return R
      */
     @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TDelayNodeConfig tDelayNodeConfig) {
          return R.ok(tDelayNodeConfigService.save(tDelayNodeConfig));
     }

     /**
      * 修改记录
      *
      * @param tDelayNodeConfig
      * @return R
      */
     @Operation(summary = "新增")
     @SysLog("修改定时流程节点配置")
     @PutMapping
     public R<Boolean> update(@RequestBody TDelayNodeConfig tDelayNodeConfig) {
          return R.ok(tDelayNodeConfigService.updateById(tDelayNodeConfig));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(summary = "删除")
     @SysLog("删除定时流程节点配置")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tDelayNodeConfigService.removeById(id));
     }

}
