package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TProcessApprovalConf;
import com.yifu.cloud.plus.v1.yifu.process.service.TProcessApprovalConfService;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;


/**
 * 审批配置表
 *
 * @author wangan
 * @date 2020-12-03 09:58:15
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tprocessapprovalconf")
@Tag(name = "审批配置表")
public class TProcessApprovalConfController {

	@Resource
    private TProcessApprovalConfService tProcessApprovalConfService;

    /**
     * 简单分页查询
     *
     * @param page                 分页对象
     * @param tProcessApprovalConf 审批配置表
     * @return
     */
	@Operation(summary = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TProcessApprovalConf>> getTProcessApprovalConfPage(Page<TProcessApprovalConf> page, TProcessApprovalConf tProcessApprovalConf) {
        return new R<>(tProcessApprovalConfService.getTProcessApprovalConfPage(page, tProcessApprovalConf));
    }


    /**
     * 通过id查询单条记录
     *
     * @param id
     * @return R
     */
	@Operation(summary = "id查询")
    @GetMapping("/{id}")
    public R<TProcessApprovalConf> getById(@PathVariable("id") String id) {
        return new R<>(tProcessApprovalConfService.getById(id));
    }


    /**
     * 新增记录
     *
     * @param tProcessApprovalConf
     * @return R
     */
	@Operation(summary = "新增")
    @PostMapping
    public R<Boolean> save(@Valid @RequestBody TProcessApprovalConf tProcessApprovalConf) {
        return new R<>(tProcessApprovalConfService.save(tProcessApprovalConf));
    }

    /**
     * 修改记录
     *
     * @param tProcessApprovalConf
     * @return R
     */
	@Operation(summary = "修改")
    @SysLog("修改审批配置表")
    @PutMapping
    public R<Boolean> update(@RequestBody TProcessApprovalConf tProcessApprovalConf) {
        return new R<>(tProcessApprovalConfService.updateById(tProcessApprovalConf));
    }

    /**
     * 通过id删除一条记录
     *
     * @param id
     * @return R
     */
	@Operation(summary = "删除")
    @SysLog("删除审批配置表")
    @DeleteMapping("/{id}")
    public R<Boolean> removeById(@PathVariable String id) {
        return new R<>(tProcessApprovalConfService.removeById(id));
    }

    /**
     * todo
	 * @param processId
     * @Author: wangan
     * @Date: 2020/12/7
     * @Description: 通过流程获取记录
     * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<TProcessApprovalConf>
     * @see com.yifu.cloud.plus.v1.process.controller
     **/
    @Inner
    @GetMapping("/inner/getRecord/byProcessId")
    public R<List<TProcessApprovalConf>> getRecordByProcessId(@RequestParam("processId") String processId) {
        List<TProcessApprovalConf> processApprovalConf = tProcessApprovalConfService.list(Wrappers.<TProcessApprovalConf>query().lambda().eq(TProcessApprovalConf::getProcessId, processId));
        return new R<>(processApprovalConf);
    }

}
