package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 工资报账配置
 *
 * @author hgw
 * @date 2019-09-12 15:46:57
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_config_salary")
@Tag(name="薪资配置-普通薪资配置")
public class TConfigSalary extends BaseEntity implements Serializable {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description="主键")
     private String id;
     /**
      * 配置名称
      */
     @NotBlank(message = "配置名称不能为空")
     @Length(max=50,message = "配置名称不能超过50个字符")
     @ExcelAttribute(name = "配置名称", isNotEmpty = true,errorInfo  = "配置名称不能为空" , maxLength = 50 )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="配置名称")
     private String name;
     /**
      * 结算主体ID
      */
     @NotBlank(message = "结算主体ID不能为空")
     @Length(max=32,message = "结算主体ID不能超过32个字符")
     @ExcelAttribute(name = "结算主体ID", isNotEmpty = true,errorInfo  = "结算主体ID不能为空" , maxLength = 32 )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="结算主体ID")
     private String departId;
     /**
      * 结算主体编码
      */
     @NotBlank(message = "结算主体编码不能为空")
     @Length(max=32,message = "结算主体编码不能超过32个字符")
     @ExcelAttribute(name = "结算主体编码", isNotEmpty = true,errorInfo  = "结算主体编码不能为空" , maxLength = 32 )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="结算主体编码")
     private String departNo;
     /**
      * 结算主体名称
      */
     @NotBlank(message = "结算主体名称不能为空")
     @Length(max=50,message = "结算主体名称不能超过50个字符")
     @ExcelAttribute(name = "结算主体名称", isNotEmpty = true,errorInfo  = "结算主体名称不能为空" , maxLength = 50 )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="结算主体名称")
     private String departName;
     /**
      * 工资月份
      */
     @NotNull(message = "工资月份不能为空")
     @ExcelAttribute(name = "工资月份", isNotEmpty = true,errorInfo  = "工资月份不能为空" )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="工资月份")
     private Integer salaryMonth;

     /**
      * 社保月份
	  * 	                    '-6': '前6月',
	  *                         '-5': '前5月',
	  *                         '-4': '前4月',
	  *                         '-3': '前3月',
	  *                         '-2': '前2月',
	  *                         '-1': '上月',
	  *                         0: '本月',
	  *                         1: '下月',
      */
     @NotNull(message = "社保月份不能为空")
     @ExcelAttribute(name = "社保月份", isNotEmpty = true,errorInfo  = "社保月份不能为空" )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="社保月份")
     private Integer socialMonth;
     /**
      * 公积金月份
      */
     @NotNull(message = "公积金月份不能为空")
     @ExcelAttribute(name = "公积金月份", isNotEmpty = true,errorInfo  = "公积金月份不能为空" )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="公积金月份")
     private Integer fundMonth;
     /**
      * 社保优先级
      */
     @NotNull(message = "社保优先级不能为空")
     @ExcelAttribute(name = "社保优先级", isNotEmpty = true,errorInfo  = "社保优先级不能为空" )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="社保优先级（0：生成；1：缴纳）")
     private Integer socialPriority;
     /**
      * 公积金优先级
      */
     @NotNull(message = "公积金优先级不能为空")
     @ExcelAttribute(name = "公积金优先级", isNotEmpty = true,errorInfo  = "公积金优先级不能为空" )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="公积金优先级（0：生成；1：缴纳）")
     private Integer fundPriority;
     /**
      * 发放方式
      */
     @NotNull(message = "发放方式不能为空")
     @ExcelAttribute(name = "发放方式", isNotEmpty = true,errorInfo  = "发放方式不能为空" )
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="发放方式（0：现金；1：转账）")
     private Integer grantType;

	/**
	 * 收入月份
	 */
	@NotNull(message = "收入月份不能为空")
	@ExcelAttribute(name = "收入月份", isNotEmpty = true,errorInfo  = "收入月份不能为空" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="收入月份")
	private Integer incomeMonth;

	/**
	 * 月均发薪次数
	 */
	@NotNull(message = "月均发薪次数不能为空")
	@ExcelAttribute(name = "月均发薪次数", isNotEmpty = true,errorInfo  = "月均发薪次数不能为空" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value="月均发薪次数")
	private Integer salaryNum;

	/**
	 * @Description: 本结算月发薪次数：0：可以提交； 其他：不可提交
	 * @Author: hgw
	 * @Date: 2023/6/25 17:45
	 * @return:
	 **/
	@TableField(exist = false)
	private Integer nowMonthSalaryNum = 0;

	/**
	 * @Description: 本结算年未提交的发薪次数：0：可以提交； 其他：提交时二次确认
	 * @Author: hgw
	 * @Date: 2023/6/25 17:45
	 * @return:
	 **/
	@TableField(exist = false)
	private Integer nowYearSalaryNum = 0;
}
