package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 有工资没有社保(首页提醒定时任务）
 *
 * @author wangan
 * @date 2019-11-26 09:34:58
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_have_salary_nosocial")
@Tag(name = "有资没有社保(首页提醒定时任务）")
public class THaveSalaryNosocial extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键", name = "id")
    private String id;
    /**
     * 员工ID
     */
    @Length(max = 32, message = "员工ID不能超过32个字符")
    @ExcelAttribute(name = "员工ID", maxLength = 32)
    @Schema(description = "员工ID", name = "employeeId")
    private String employeeId;
	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50,needExport=true)
	@Schema(description = "客户名称", name = "customerName")
	private String customerName;
	/**
	 * 结算主体名称
	 */
	@NotBlank(message = "结算主体名称不能为空")
	@Length(max = 50, message = "结算主体名称不能超过50个字符")
	@ExcelAttribute(name = "结算主体名称", isNotEmpty = true, errorInfo = "结算主体名称不能为空", maxLength = 50,needExport=true)
	@Schema(description = "结算主体名称", name = "settlementOrganName")
	private String settlementOrganName;
	/**
     * 员工名称
     */
    @Length(max = 32, message = "员工名称不能超过32个字符")
    @ExcelAttribute(name = "员工名称", maxLength = 32,needExport=true)
    @Schema(description = "员工名称", name = "employeeName")
    private String employeeName;
	/**
     * 身份证号
     */
    @Length(max = 32, message = "身份证号不能超过32个字符")
    @ExcelAttribute(name = "身份证号", maxLength = 32,needExport=true)
    @Schema(description = "身份证号", name = "employeeIdCard")
    private String employeeIdCard;
	/**
	 * 工资月份
	 */
	@NotBlank(message = "工资月份不能为空")
	@ExcelAttribute(name = "工资月份", isNotEmpty = true, errorInfo = "工资月份不能为空",needExport=true)
	@Schema(description = "工资月份", name = "month")
	private String month;
	/**
	 * 应发工资
	 */
	@Schema(description = "应发工资", name = "relaySalary")
	@ExcelAttribute(name = "应发工资", isNotEmpty = true, errorInfo = "应发工资不能为空", needExport = true)
	private String relaySalary;

	/**
     * 单位ID
     */
    @Length(max = 255, message = "单位ID不能超过255个字符")
    @ExcelAttribute(name = "单位ID", maxLength = 255)
    @Schema(description = "单位ID", name = "customerId")
    private String customerId;
	/**
     * 部门ID
     */
    @Length(max = 255, message = "部门ID不能超过255个字符")
    @ExcelAttribute(name = "部门ID", maxLength = 255)
    @Schema(description = "部门ID", name = "settleDomainId")
    private String settleDomainId;
	/**
     * 结算主体编码
     */
    @NotBlank(message = "结算主体编码不能为空")
    @Length(max = 50, message = "结算主体编码不能超过50个字符")
    @ExcelAttribute(name = "结算主体编码", isNotEmpty = true, errorInfo = "结算主体编码不能为空", maxLength = 50,needExport=true)
    @Schema(description = "结算主体编码", name = "settlementOrganNo")
    private String settlementOrganNo;

	/**
     * 生成月--- 生成数据的月份 删除用
     */
    @Length(max = 10, message = "生成月不能超过10个字符")
    @ExcelAttribute(name = "生成月", maxLength = 10, needExport = true)
    @Schema(description = "生成月", name = "createMonth")
    private String createMonth;


    /**
     * 原因大类 根据数据字典来判断
     */
    @Schema(description = "原因大类 根据数据字典来判断 ", name = "reasonType")
    @ExcelAttribute(name = "原因大类", errorInfo = "原因大类不能为空", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.HAVE_SALARY_NO_SOCIAL_TYPE, needExport = true)
    private Integer reasonType;
	/**
	 * 反馈原因
	 */
	@Schema(description = "反馈原因", name = "reasonType")
	@ExcelAttribute(name = "反馈原因",  maxLength = 32, needExport = true)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "反馈原因")
	private String feedBack;

}
