package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 薪资识别配置（标准模板）
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_salary_config_standard")
@Tag(name = "薪资识别配置（标准模板）")
public class TSalaryConfigStandard extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
    private String id;
    /**
     * 中文名（Excel表头）
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "中文名（Excel表头）")
    @Length(max = 32, message = "中文名（Excel表头）不能超过32个字符")
    @NotBlank(message = "中文名（Excel表头）不能为空")
    @ExcelAttribute(name = "中文名（Excel表头）", isNotEmpty = true, errorInfo = "中文名（Excel表头）不能为空", maxLength = 32)
    private String cnName;
    /**
     * 数据库字段名
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "数据库字段名")
    @Length(max = 32, message = "数据库字段名不能超过32个字符")
    @ExcelAttribute(name = "数据库字段名", maxLength = 32)
    private String dbFiedName;
    /**
     * JAVA属性字段名
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "JAVA属性字段名")
    @Length(max = 32, message = "JAVA属性字段名不能超过32个字符")
    @ExcelAttribute(name = "JAVA属性字段名", maxLength = 32)
    private String javaFiedName;
    /**
     * 模板类型（数据字典）
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "模板类型（数据字典）")
    @Length(max = 32, message = "模板类型（数据字典）不能超过32个字符")
    @NotBlank(message = "模板类型（数据字典）不能为空")
    @ExcelAttribute(name = "模板类型（数据字典）", isNotEmpty = true, errorInfo = "模板类型（数据字典）不能为空", maxLength = 32)
    private String modelType;
    /**
     * 是否是必须
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否是必须（0：不是；1：必填）")
    @NotBlank(message = "是否是必须不能为空")
    @ExcelAttribute(name = "是否是必须", isNotEmpty = true, errorInfo = "是否是必须不能为空")
    private String isMustNeed;

    /**
     * 是否进行计算扣税：1：计算；0：不计算
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否进行计算扣税：1：计算；0：不计算")
    @NotBlank(message = "是否进行计算扣税不能为空")
    @ExcelAttribute(name = "是否进行计算扣税", isNotEmpty = true, errorInfo = "是否进行计算扣税不能为空")
    private Integer isTax;

    /**
     * 排序项
     */
    @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "排序项")
    @ExcelAttribute(name = "排序项", maxLength = 32)
    private String orderLine;

}
