package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Description: B端-结算单Vo
 * @Author: hgw
 * @Date: 2020-8-21 11:31:03
 * @return:
 **/
@Getter
@Setter
public class SalaryAccountAndItemVo implements Serializable {
     private static final long serialVersionUID = 1L;

     /**
      * 主键
      */
     @Schema(description = "主键", name = "id")
     private String id;
     /**
      * 工资表id
      */
     @Schema(description = "工资表id", name = "salaryFormId")
     private String salaryFormId;
     /**
      * 工资月
      */
     @Schema(description = "工资月", name = "salaryDate")
     private String salaryDate;
     /**
      * 员工姓名
      */
     @Schema(description = "员工姓名", name = "empName")
     private String empName;
     /**
      * 员工身份证号
      */
     @Schema(description = "员工身份证号", name = "empIdcard")
     private String empIdcard;
     /**
      * 工资发放时间（0立即发、1暂停发）
      */
     @Schema(description = "工资发放时间（0立即发、1暂停发）", name = "salaryGiveTime")
     private String salaryGiveTime;
     /**
      * 发放状态 0: 未发放 1: 发放成功 2:发放失败
      */
     @Schema(description = "发放状态 0: 未发放 1: 发放成功 2:发放失败", name = "distributionFlag")
     private String distributionFlag;
     /**
      * 社保扣缴月份
      */
     @Schema(description = "社保扣缴月份", name = "deduSocialMonth")
     private String deduSocialMonth;
     /**
      * 公积金扣缴月份
      */
     @Schema(description = "公积金扣缴月份", name = "deduProvidentMonth")
     private String deduProvidentMonth;
     /**
      * 财务类型 0：工资；1：绩效；2：其他
      */
     @Schema(description = "财务类型 0：工资；1：绩效；2：其他", name = "salaryType")
     private String salaryType;
     /**
      * 结算月
      */
     @Schema(description = "结算月", name = "settlementMonth")
     private String settlementMonth;
     /**
      * 应发工资
      */
     @Schema(description = "应发工资", name = "relaySalary")
     private String relaySalary;
     /**
      * 实发工资
      */
     @Schema(description = "实发工资", name = "actualSalarySum")
     private String actualSalarySum;
     /**
      * 个税
      */
     @Schema(description = "个税", name = "salaryTax")
     private String salaryTax;

     /**
      * 年
      */
     @Schema(description = "年", name = "years")
     private String years;

     /**
      * 单位社保
      */
     @Schema(description = "单位社保", name = "unitSocial")
     private String unitSocial;

     /**
      * 个人社保
      */
     @Schema(description = "个人社保", name = "personalSocial")
     private String personalSocial;

     /**
      * 单位公积金
      */
     @Schema(description = "单位公积金", name = "unitFund")
     private String unitFund;

     /**
      * 个人公积金
      */
     @Schema(description = "个人公积金", name = "personalFund")
     private String personalFund;

     /**
      * 发放时间
      */
     @Schema(description = "发放时间", name = "revenueTime")
     private Date revenueTime;

     /**
      * 工资组成部分明细
      */
     private List<TSalaryAccountItem> saiList = new ArrayList<>();

}
