package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.THaveSalaryNosocial;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 有工资没有社保(首页提醒定时任务）
 *
 * @author wangan
 * @date 2019-11-26 09:34:58
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Tag(name = "有资没有社保(首页提醒定时任务）")
public class THaveSalaryNosocialHandleExportVo extends THaveSalaryNosocial {
    private static final long serialVersionUID = 1L;


    @TableField(exist = false)
    @Schema(description = "原因大类 根据数据字典来判断 ", name = "lastOneReasonType")
    @ExcelAttribute(name = "前一月原因大类",  maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.HAVE_SALARY_NO_SOCIAL_TYPE, needExport = true)
    private Integer lastOneReasonType;


    @TableField(exist = false)
    @Schema(description = "原因大类 根据数据字典来判断 ", name = "lastTwoReasonType")
    @ExcelAttribute(name = "前二月原因大类",  maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.HAVE_SALARY_NO_SOCIAL_TYPE, needExport = true)
    private Integer lastTwoReasonType;


    @TableField(exist = false)
    @Schema(description = "原因大类 根据数据字典来判断 ", name = "lastThreeReasonType")
    @ExcelAttribute(name = "前三月原因大类", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.HAVE_SALARY_NO_SOCIAL_TYPE, needExport = true)
    private Integer lastThreeReasonType;




}
