package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 含风险项目不购买申请明细表
 *
 * @author huych
 * @date 2025-01-10 11:23:21
 */
@Data
@ColumnWidth(25)
public class TInsuranceUnpurchasePersonVo implements Serializable {

	/**
	 * 明细单号
	 */
	@ExcelAttribute(name = "明细单号")
	@Schema(description = "明细单号")
	@ExcelProperty("明细单号")
	private String applyNoDetail;

	/**
	 * 不购买申请流程单号
	 */
	@ExcelAttribute(name = "不购买申请编号")
	@Schema(description = "不购买申请编号")
	@ExcelProperty("不购买申请编号")
	private String applyNo;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	@ExcelProperty("项目名称")
	private String deptName;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "事业部条线")
	@Schema(description = "事业部条线")
	@ExcelProperty("事业部条线")
	private String newLine;

	@ExcelAttribute(name = "事业部")
	@Schema(description = "事业部")
	@ExcelProperty("事业部")
	private String division;

	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcardNo;

	/**
	 * 不购买原因 1 已购买社保 2 人员已离职
	 */
	@ExcelAttribute(name = "不购买原因")
	@Schema(description = "不购买原因")
	@ExcelProperty("不购买原因")
	private String reasonType;

	/**
	 * 社保是否在保 0 是 1 否
	 */
	@ExcelAttribute(name = "社保是否在保")
	@Schema(description = "社保是否在保")
	@ExcelProperty("社保是否在保")
	private String socialStatus;

	/**
	 * 发薪次数
	 */
	@ExcelAttribute(name = "发薪次数")
	@Schema(description = "发薪次数")
	@ExcelProperty("发薪次数")
	private Integer salaryNum;

	/**
	 * 创建者-姓名
	 */
	@ExcelAttribute(name = "申请人")
	@Schema(description = "申请人")
	@ExcelProperty("申请人")
	private String createName;

	/**
	 * 申请时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@ExcelAttribute(name = "申请时间")
	@Schema(description = "申请时间")
	@ExcelProperty("申请时间")
	private LocalDateTime createTime;

}
