/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 薪资详情里的报账导出-EKP附件专用
 * 薪资详情里的报账导出，是前端导出，此处后端导出，给EKP项目订单获取附件使用的
 *
 * @author hgw
 * @date 2024-4-18 17:04:21
 */
@Data
@Schema(description = "薪资详情里的报账导出-EKP附件专用")
@HeadFontStyle(fontHeightInPoints = 11)
public class TSalaryAccountExportByEkpVo {

	// 薪酬状态,项目名称,项目编码,发放月份,薪酬月份,员工姓名,身份证号,手机号码,银行卡号,开户行总行
	// ,应发工资,个人社保,个人公积金,个税,年终奖单独扣税税费,企业（职业）年金,个人代扣金额,个人实发合计,单位社保,单位公积金
	// ,减除费用,累计子女教育,累计继续教育,累计住房贷款利息,累计住房租金,累计赡养老人,累计3岁以下婴幼儿照护,累计个人养老金,年终奖扣税方案,开户行省
	// ,开户行市,开户行支行,工资发放方式,工资发放时间,社保缴纳月份,公积金缴纳月份,社保优先级,公积金优先级,是否扣除社保,是否扣除公积金
	// ,本月是否重复金额,是否自有员工,是否薪资特殊值,支出结算状态
	@ExcelProperty("薪酬状态")
	private String status;
	@ExcelProperty("项目名称")
	private String deptName;
	@ExcelProperty("项目编码")
	private String deptNo;
	@ExcelProperty("发放月份")
	private String settlementMonth;
	@ExcelProperty("薪酬月份")
	private String salaryMonth;
	@ExcelProperty("员工姓名")
	private String empName;
	@ExcelProperty("身份证号")
	private String empIdcard;
	@ExcelProperty("手机号码")
	private String empPhone;
	// 银行卡号
	@ExcelProperty("银行卡号")
	private String bankNo;
	// 开户行总行
	@ExcelProperty("开户行总行")
	private String bankName;
	// ,应发工资,个人社保,个人公积金,个税,年终奖单独扣税税费,企业（职业）年金,个人代扣金额,个人实发合计,单位社保,单位公积金
	@ExcelProperty("应发工资")
	private BigDecimal relaySalary;
	@ExcelProperty("个人社保")
	private BigDecimal personSocial;
	@ExcelProperty("个人公积金")
	private BigDecimal personFund;
	@ExcelProperty("个税")
	private BigDecimal salaryTax;
	@ExcelProperty(value = "年终奖单独扣税税费")
	private BigDecimal annualBonusTax;
	@ExcelProperty("企业（职业）年金")
	private BigDecimal enterpriseAnnuity;
	@ExcelProperty("个人代扣金额")
	private String pdeductionMoney;
	@ExcelProperty("个人实发合计")
	private BigDecimal actualSalary;
	@ExcelProperty("单位社保")
	private BigDecimal unitSocial;
	@ExcelProperty("单位公积金")
	private BigDecimal unitFund;
	// ,减除费用,累计子女教育,累计继续教育,累计住房贷款利息,累计住房租金,累计赡养老人,累计3岁以下婴幼儿照护,累计个人养老金,年终奖扣税方案,开户行省
	@ExcelProperty("减除费用")
	private BigDecimal costReduction;
	@ExcelProperty(value = "累计子女教育")
	private BigDecimal sumChildEduMoney;
	@ExcelProperty(value = "累计继续教育")
	private BigDecimal sumContinuingEducationMoney;
	@ExcelProperty(value = "累计住房贷款利息")
	private BigDecimal sumHousingLoanMoney;
	@ExcelProperty(value = "累计住房租金")
	private BigDecimal sumHousingRentMoney;
	@ExcelProperty(value = "累计赡养老人")
	private BigDecimal sumSupportElderlyMoney;
	@ExcelProperty(value = "累计3岁以下婴幼儿照护")
	private BigDecimal sumBabyMoney;
	@ExcelProperty(value = "累计个人养老金")
	private BigDecimal sumPrivatePension;
	// 年终奖扣税方案0：合并；1：单独
	@ExcelProperty("年终奖扣税方案")
	private String annualBonusType;
	// 开户行省
	@ExcelProperty("开户行省")
	private String bankProvince;
	// ,开户行市,开户行支行,工资发放方式,工资发放时间,社保缴纳月份,公积金缴纳月份,社保优先级,公积金优先级,是否扣除社保,是否扣除公积金
	// 开户行市
	@ExcelProperty("开户行市")
	private String bankCity;
	// 开户行支行
	@ExcelProperty("开户行支行")
	private String bankSubName;
	// 工资发放方式（0现金/1银行）/2线下
	@ExcelProperty("工资发放方式")
	private String salaryStyle;
	// 工资发放时间（0立即发、1暂停发）
	@ExcelProperty("工资发放时间")
	private String salaryGiveTime;
	// 社保缴纳月份
	@ExcelProperty("社保缴纳月份")
	private String deduSocialMonth;
	// 公积金缴纳月份
	@ExcelProperty("公积金缴纳月份")
	private String deduProvidentMonth;
	// 社保优先级0：生成月；1：缴纳月
	@ExcelProperty("社保优先级")
	private String socialPriority;
	// 公积金优先级0：生成月；1：缴纳月
	@ExcelProperty("公积金优先级")
	private String fundPriority;
	// 是否扣除社保 0:否,1:是
	@ExcelProperty("是否扣除社保")
	private String isDeductSocial;
	// 是否扣除公积金 0:否,1:是
	@ExcelProperty("是否扣除公积金")
	private String isDeductFund;
	// ,本月是否重复金额,是否自有员工,是否薪资特殊值,支出结算状态
	// 本月是否重复金额0：否；1：是重复导入的
	@ExcelProperty("本月是否重复金额")
	private String isRepeat;
	// 是否自有员工0：否；1：是自有员工
	@ExcelProperty("是否自有员工")
	private String ownFlag;
	// 是否含有特殊金额
	@ExcelProperty("是否薪资特殊值")
	private String haveSpecialFlag;
	@ExcelProperty("支出结算状态")
	private String paySettleFlag;

	/*@ExcelProperty("免个税个人代扣")
	private BigDecimal exemptionPersionTax;
	@ExcelProperty("是否劳务费")
	private String formType;
	@ExcelProperty("计税月份")
	private String taxMonth;
	@ExcelProperty("出账单位")
	private String invoiceTitle;
	@ExcelProperty("业务类型分类")
	private String businessPrimaryType;
	@ExcelProperty("业务类型二级分类")
	private String businessSecondType;
	@ExcelProperty("业务类型三级分类")
	private String businessThirdType;
	@ExcelProperty("年终奖")
	private BigDecimal annualBonus;
	@ExcelProperty("通讯补贴（不计税）")
	private BigDecimal phoneSubsidy;
	@ExcelProperty("表单上传人")
	private String createName;
	@ExcelProperty("个人代扣明细")
	private String pdeductionDetail;
	@ExcelProperty("结算单位")
	private String unitName;
	@ExcelProperty("结算单位编码")
	private String unitNo;*/

}
