package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 工资报账表附加-工资明细
 *
 * @author hgw
 * @date 2019-07-30 15:00:05
 */
@Data
public class TSalaryAccountItemVo extends Model<TSalaryAccountItemVo> {
	private static final long serialVersionUID = 1L;

	/**
	 * 表头名称
	 */
	@Length(max = 50, message = "表头名称不能超过50个字符")
	@NotBlank(message = "表头名称不能为空")
	@ExcelAttribute(name = "表头名称", isNotEmpty = true, errorInfo = "表头名称不能为空", maxLength = 50)
	private String cnName;
	/**
	 * JAVA属性名称
	 */
	@Length(max = 32, message = "JAVA属性名称不能超过32个字符")
	@NotBlank(message = "JAVA属性名称不能为空")
	@ExcelAttribute(name = "JAVA属性名称", isNotEmpty = true, errorInfo = "JAVA属性名称不能为空", maxLength = 32)
	private String javaFiedName;
	/**
	 * 属性值
	 */
	@ExcelAttribute(name = "属性值")
	private BigDecimal salaryMoney;

	/**
	 * 文本值
	 */
	@Length(max = 100, message = "文本值不能超过100个字符")
	@ExcelAttribute(name = "文本值", maxLength = 100)
	private String textValue;

	/**
	 * 是否进行计算扣税：1：计算；0：不计算
	 */
	@NotBlank(message = "是否进行计算扣税不能为空")
	@ExcelAttribute(name = "是否进行计算扣税", isNotEmpty = true, errorInfo = "是否进行计算扣税不能为空")
	private Integer isTax;

}
