/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 薪酬人员表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryEmployeeVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 员工姓名
	 */
	@NotBlank(message = "员工姓名 不能为空")
	@Length(max = 32, message = "员工姓名 不能超过32 个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名 不能为空", maxLength = 32)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@NotBlank(message = "身份证号 不能为空")
	@Length(max = 32, message = "身份证号 不能超过32 个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号 不能为空", maxLength = 32)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;
	/**
	 * 客户id
	 */
	@Length(max = 32, message = "客户id 不能超过32 个字符")
	@ExcelAttribute(name = "客户id", maxLength = 32)
	@Schema(description = "客户id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户id")
	private String unitId;
	/**
	 * 客户名称
	 */
	@Length(max = 50, message = "客户名称 不能超过50 个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@Length(max = 32, message = "客户编码 不能超过32 个字符")
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Schema(description = "客户编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	private String unitNo;
	/**
	 * 项目id
	 */
	@Length(max = 32, message = "项目id 不能超过32 个字符")
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Schema(description = "项目id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目id")
	private String deptId;
	/**
	 * 项目名称
	 */
	@Length(max = 50, message = "项目名称 不能超过50 个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@Length(max = 30, message = "项目编码 不能超过30 个字符")
	@ExcelAttribute(name = "项目编码", maxLength = 30)
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;
	/**
	 * 开户行总行
	 */
	@Length(max = 50, message = "开户行总行 不能超过50 个字符")
	@ExcelAttribute(name = "开户行总行", maxLength = 50)
	@Schema(description = "开户行总行")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行总行")
	private String bankName;
	/**
	 * 开户行支行
	 */
	@Length(max = 50, message = "开户行支行 不能超过50 个字符")
	@ExcelAttribute(name = "开户行支行", maxLength = 50)
	@Schema(description = "开户行支行")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行支行")
	private String bankSubName;
	/**
	 * 银行卡号
	 */
	@Length(max = 50, message = "银行卡号 不能超过50 个字符")
	@ExcelAttribute(name = "银行卡号", maxLength = 50)
	@Schema(description = "银行卡号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("银行卡号")
	private String bankNo;
	/**
	 * 封面抬头
	 */
	@Length(max = 50, message = "封面抬头 不能超过50 个字符")
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	@Schema(description = "封面抬头")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头")
	private String invoiceTitle;
	/**
	 * 开户行省
	 */
	@ExcelAttribute(name = "开户行省")
	@Schema(description = "开户行省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行省")
	private String bankProvince;
	/**
	 * 开户行市
	 */
	@ExcelAttribute(name = "开户行市")
	@Schema(description = "开户行市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("开户行市")
	private String bankCity;
	/**
	 * 手机号码
	 */
	@Length(max = 32, message = "手机号码 不能超过32 个字符")
	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Schema(description = "手机号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	private String empPhone;
	/**
	 * 计税月份
	 */
	@Length(max = 6, message = "计税月份 不能超过6 个字符")
	@ExcelAttribute(name = "计税月份", maxLength = 6)
	@Schema(description = "计税月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("计税月份")
	private String taxMonth;
	/**
	 * 在职状态（0在职；1离职）
	 */
	@ExcelAttribute(name = "在职状态（0在职；1离职）")
	@Schema(description = "在职状态（0在职；1离职）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("在职状态（0在职；1离职）")
	private Integer fileStatus;

}
