package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author fxj
 * @Date 2022/8/8
 * @Description
 * @Version 1.0
 */
@Data
public class TSalaryStandardExportVo implements Serializable {
	/**
	 * 状态0待提交   1待审核  2审核通过   3发送成功   5审核不通过   10 发送失败
	 */
	@ExcelAttribute(name = "状态", isDataId = true, readConverterExp = "0=待提交,1=待审核,2=待推送明细,3=发送成功,5=审核不通过,6=确认不通过,10=发送失败,11=已审核生成收入中,12=已审核生成收入失败")
	@NotBlank(message = "状态（0待提交   1待审核  2审核通过   3发送成功   5审核不通过   10 发送失败）不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("薪酬状态")
	private String status;
	/**
	 * 推送月份（YYYYMM）
	 */
	@ExcelAttribute(name = "推送月份", isNotEmpty = true, errorInfo = "推送月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "推送月份（YYYYMM）不能为空")
	@Length(max = 6, message = "推送月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("发放月份")
	private String sendMonth;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称",errorInfo = "项目名称不能为空", maxLength = 50)
	@NotBlank(message = "项目名称不能为空")
	@Length(max = 50, message = "部门名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 32)
	@Length(max = 32, message = "项目编码不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;

	@ExcelAttribute(name = "申请编码", maxLength = 32)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申请编码")
	private String applyNo;

	/**
	 * 项目金额
	 */
	@ExcelAttribute(name = "项目金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目金额")
	private BigDecimal settlementAmount;
	/**
	 * 封面抬头
	 */
	@ExcelAttribute(name = "封面抬头", maxLength = 50)
	@Length(max = 50, message = "封面抬头不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头")
	private String invoiceTitle;
	/**
	 * 工资月份（YYYYMM）
	 */
	@ExcelAttribute(name = "工资月份（YYYYMM）", isNotEmpty = true, errorInfo = "工资月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "工资月份（YYYYMM）不能为空")
	@Length(max = 6, message = "工资月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("薪酬月份")
	private String salaryMonth;
	/**
	 * 表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬
	 */
	@ExcelAttribute(name = "表单类型", isDataId = true, readConverterExp = "0=薪资,1=绩效,2=其他,3=劳务费,4=稿酬")
	@NotBlank(message = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬不能为空")
	@Length(max = 32, message = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("表单类型")
	private String formType;


	@ExcelAttribute(name = "代发户状态（0正常；1代发户）"  )
	@ExcelProperty("代发户状态")
	@Schema(description ="代发户状态（0正常；1代发户）")
	private String issueStatus;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;
	/**
	 * 创建者-姓名
	 */
	@Schema(description = "创建人-姓名")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人")
	private String createName;
}
