/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标准薪酬工资表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryStandardVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 部门ID
	 */
	@NotBlank(message = "部门ID 不能为空")
	@Length(max = 32, message = "部门ID 不能超过32 个字符")
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID 不能为空", maxLength = 32)
	@Schema(description = "部门ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String deptId;
	/**
	 * 部门名称
	 */
	@NotBlank(message = "部门名称 不能为空")
	@Length(max = 50, message = "部门名称 不能超过50 个字符")
	@ExcelAttribute(name = "部门名称", isNotEmpty = true, errorInfo = "部门名称 不能为空", maxLength = 50)
	@Schema(description = "部门名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门名称")
	private String deptName;
	/**
	 * 部门编码
	 */
	@Length(max = 32, message = "部门编码 不能超过32 个字符")
	@ExcelAttribute(name = "部门编码", maxLength = 32)
	@Schema(description = "部门编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门编码")
	private String deptNo;
	/**
	 * 结算金额
	 */
	@ExcelAttribute(name = "结算金额")
	@Schema(description = "结算金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算金额")
	private BigDecimal settlementAmount;
	/**
	 * 所属分公司id（创建人的部门id）
	 */
	@NotBlank(message = "所属分公司id（创建人的部门id） 不能为空")
	@Length(max = 32, message = "所属分公司id（创建人的部门id） 不能超过32 个字符")
	@ExcelAttribute(name = "所属分公司id（创建人的部门id）", isNotEmpty = true, errorInfo = "所属分公司id（创建人的部门id） 不能为空", maxLength = 32)
	@Schema(description = "所属分公司id（创建人的部门id）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属分公司id（创建人的部门id）")
	private String belongDeptId;
	/**
	 * 所属分公司CODE（创建人的部门CODE）
	 */
	@NotBlank(message = "所属分公司CODE（创建人的部门CODE） 不能为空")
	@Length(max = 50, message = "所属分公司CODE（创建人的部门CODE） 不能超过50 个字符")
	@ExcelAttribute(name = "所属分公司CODE（创建人的部门CODE）", isNotEmpty = true, errorInfo = "所属分公司CODE（创建人的部门CODE） 不能为空", maxLength = 50)
	@Schema(description = "所属分公司CODE（创建人的部门CODE）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所属分公司CODE（创建人的部门CODE）")
	private String belongDeptCode;
	/**
	 * 结算月份（YYYYMM）
	 */
	@NotBlank(message = "结算月份（YYYYMM） 不能为空")
	@Length(max = 6, message = "结算月份（YYYYMM） 不能超过6 个字符")
	@ExcelAttribute(name = "结算月份（YYYYMM）", isNotEmpty = true, errorInfo = "结算月份（YYYYMM） 不能为空", maxLength = 6)
	@Schema(description = "结算月份（YYYYMM）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算月份（YYYYMM）")
	private String settlementMonth;
	/**
	 * 表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬
	 */
	@NotBlank(message = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬 不能为空")
	@Length(max = 32, message = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬 不能超过32 个字符")
	@ExcelAttribute(name = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬", isNotEmpty = true, errorInfo = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬 不能为空", maxLength = 32)
	@Schema(description = "表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬")
	private String formType;
	/**
	 * 备注
	 */
	@Length(max = 500, message = "备注 不能超过500 个字符")
	@ExcelAttribute(name = "备注", maxLength = 500)
	@Schema(description = "备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remark;
	/**
	 * 工资月份（YYYYMM）
	 */
	@NotBlank(message = "工资月份（YYYYMM） 不能为空")
	@Length(max = 6, message = "工资月份（YYYYMM） 不能超过6 个字符")
	@ExcelAttribute(name = "工资月份（YYYYMM）", isNotEmpty = true, errorInfo = "工资月份（YYYYMM） 不能为空", maxLength = 6)
	@Schema(description = "工资月份（YYYYMM）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工资月份（YYYYMM）")
	private String salaryMonth;
	/**
	 * 款项来源（0客户到款/1垫付）
	 */
	@ExcelAttribute(name = "款项来源（0客户到款/1垫付）")
	@Schema(description = "款项来源（0客户到款/1垫付）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("款项来源（0客户到款/1垫付）")
	private Integer moneyFrom;
	/**
	 * 状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印）
	 */
	@NotBlank(message = "状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印） 不能为空")
	@ExcelAttribute(name = "状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印）", isNotEmpty = true, errorInfo = "状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印） 不能为空")
	@Schema(description = "状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("状态（0待提交1待审核2:待推送3已推送待发放4已发放5审核不通过6确认不通过7财务退回8：结算单调整待审核 9: 结算单调整待打印）")
	private Integer status;
	/**
	 * 提交时间
	 */
	@ExcelAttribute(name = "提交时间", isDate = true)
	@Schema(description = "提交时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("提交时间")
	private Date submitTime;
	/**
	 * 是否删除0：未删除；1:已删除
	 */
	@NotBlank(message = "是否删除0：未删除；1:已删除 不能为空")
	@ExcelAttribute(name = "是否删除0：未删除；1:已删除", isNotEmpty = true, errorInfo = "是否删除0：未删除；1:已删除 不能为空")
	@Schema(description = "是否删除0：未删除；1:已删除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否删除0：未删除；1:已删除")
	private Integer deleteFlag;
	/**
	 * 最终审核人
	 */
	@Length(max = 32, message = "最终审核人 不能超过32 个字符")
	@ExcelAttribute(name = "最终审核人", maxLength = 32)
	@Schema(description = "最终审核人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最终审核人")
	private String auditUser;
	/**
	 * 最终审核时间
	 */
	@ExcelAttribute(name = "最终审核时间", isDate = true)
	@Schema(description = "最终审核时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最终审核时间")
	private Date auditTime;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省")
	@Schema(description = "省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("省")
	private Integer province;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市")
	@Schema(description = "市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("市")
	private Integer city;
	/**
	 * 县
	 */
	@ExcelAttribute(name = "县")
	@Schema(description = "县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("县")
	private Integer town;
	/**
	 * 类型：0：工资；1：非扣税项
	 */
	@ExcelAttribute(name = "类型：0：工资；1：非扣税项")
	@Schema(description = "类型：0：工资；1：非扣税项")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0：工资；1：非扣税项")
	private Integer type;
	/**
	 * 自有员工人数，默认0
	 */
	@ExcelAttribute(name = "自有员工人数，默认0")
	@Schema(description = "自有员工人数，默认0")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("自有员工人数，默认0")
	private Integer ownNums;
	/**
	 * 自有员工应发总额
	 */
	@ExcelAttribute(name = "自有员工应发总额")
	@Schema(description = "自有员工应发总额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("自有员工应发总额")
	private BigDecimal ownMoney;
	/**
	 * 自有员工强行提交的备注
	 */
	@Length(max = 200, message = "自有员工强行提交的备注 不能超过200 个字符")
	@ExcelAttribute(name = "自有员工强行提交的备注", maxLength = 200)
	@Schema(description = "自有员工强行提交的备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("自有员工强行提交的备注")
	private String ownRemark;
	/**
	 * 提交备注
	 */
	@Length(max = 1000, message = "提交备注 不能超过1000 个字符")
	@ExcelAttribute(name = "提交备注", maxLength = 1000)
	@Schema(description = "提交备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("提交备注")
	private String submitRemark;
	/**
	 * 创建人id
	 */
	@Length(max = 64, message = "创建人id 不能超过64 个字符")
	@ExcelAttribute(name = "创建人id", maxLength = 64)
	@Schema(description = "创建人id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人id")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 64, message = "创建人姓名 不能超过64 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 64)
	@Schema(description = "创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@Schema(description = "创建时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private Date createTime;
	/**
	 * 更新人id
	 */
	@Length(max = 32, message = "更新人id 不能超过32 个字符")
	@ExcelAttribute(name = "更新人id", maxLength = 32)
	@Schema(description = "更新人id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("更新人id")
	private String updateBy;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("更新时间")
	private Date updateTime;
	/**
	 * 客户ID
	 */
	@NotBlank(message = "客户ID 不能为空")
	@Length(max = 32, message = "客户ID 不能超过32 个字符")
	@ExcelAttribute(name = "客户ID", isNotEmpty = true, errorInfo = "客户ID 不能为空", maxLength = 32)
	@Schema(description = "客户ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户ID")
	private String unitId;
	/**
	 * 客户名称
	 */
	@NotBlank(message = "客户名称 不能为空")
	@Length(max = 50, message = "客户名称 不能超过50 个字符")
	@ExcelAttribute(name = "客户名称", isNotEmpty = true, errorInfo = "客户名称 不能为空", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@Length(max = 32, message = "客户编码 不能超过32 个字符")
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Schema(description = "客户编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	private String unitNo;

}
